"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetNonIndexableItemDetailsResponse = void 0;
const NonIndexableItemDetailsResult_1 = require("../../MailboxSearch/NonIndexableItemDetailsResult");
const ServiceResponse_1 = require("./ServiceResponse");
const XmlElementNames_1 = require("../XmlElementNames");
/**
 * Represents the GetNonIndexableItemDetails response.
 *
 * @sealed
 */
class GetNonIndexableItemDetailsResponse extends ServiceResponse_1.ServiceResponse {
    /**
     * @internal Initializes a new instance of the **GetDiscoverySearchConfigurationResponse** class.
     */
    constructor() {
        super();
        /**
         * Non indexable item result
         *
         * internal set
         */
        this.NonIndexableItemsResult = null;
    }
    /**
     * @internal Reads response elements from Xml JsObject.
     *
     * @param   {any}               jsObject   The response object.
     * @param   {ExchangeService}   service    The service.
     */
    ReadElementsFromXmlJsObject(jsObject, service) {
        //super.ReadElementsFromXmlJsObject(jsObject,service);
        if (jsObject[XmlElementNames_1.XmlElementNames.NonIndexableItemDetailsResult]) {
            this.NonIndexableItemsResult = NonIndexableItemDetailsResult_1.NonIndexableItemDetailsResult.LoadFromXmlJsObject(jsObject[XmlElementNames_1.XmlElementNames.NonIndexableItemDetailsResult], service);
        }
    }
}
exports.GetNonIndexableItemDetailsResponse = GetNonIndexableItemDetailsResponse;
//# sourceMappingURL=GetNonIndexableItemDetailsResponse.js.map