"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetInboxRulesResponse = void 0;
const ExtensionMethods_1 = require("../../ExtensionMethods");
const RuleCollection_1 = require("../../ComplexProperties/RuleCollection");
const XmlElementNames_1 = require("../XmlElementNames");
const ServiceResponse_1 = require("./ServiceResponse");
/**
 * @internal Represents the response to a GetInboxRules operation.
 *
 * @sealed
 */
class GetInboxRulesResponse extends ServiceResponse_1.ServiceResponse {
    /**
     * @internal Initializes a new instance of the **GetInboxRulesResponse** class.
     */
    constructor() {
        super();
        this.ruleCollection = new RuleCollection_1.RuleCollection();
    }
    /**
     * @internal Gets the rule collection in the response.
     */
    get Rules() {
        return this.ruleCollection;
    }
    /**
     * @internal Reads response elements from Xml JsObject.
     *
     * @param   {any}               jsObject   The response object.
     * @param   {ExchangeService}   service    The service.
     */
    ReadElementsFromXmlJsObject(responseObject, service) {
        this.ruleCollection.OutlookRuleBlobExists = ExtensionMethods_1.Convert.toBool(responseObject[XmlElementNames_1.XmlElementNames.OutlookRuleBlobExists]);
        if (responseObject[XmlElementNames_1.XmlElementNames.InboxRules]) {
            this.ruleCollection.LoadFromXmlJsObject(responseObject[XmlElementNames_1.XmlElementNames.InboxRules], service);
        }
    }
}
exports.GetInboxRulesResponse = GetInboxRulesResponse;
//# sourceMappingURL=GetInboxRulesResponse.js.map