"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetDiscoverySearchConfigurationResponse = void 0;
const DiscoverySearchConfiguration_1 = require("../../MailboxSearch/DiscoverySearchConfiguration");
const EwsServiceJsonReader_1 = require("../EwsServiceJsonReader");
const XmlElementNames_1 = require("../XmlElementNames");
const ServiceResponse_1 = require("./ServiceResponse");
/**
 * Represents the GetDiscoverySearchConfiguration response.
 *
 * @sealed
 */
class GetDiscoverySearchConfigurationResponse extends ServiceResponse_1.ServiceResponse {
    /**
     * @internal Initializes a new instance of the **GetDiscoverySearchConfigurationResponse** class.
     */
    constructor() {
        super();
        this.configurations = [];
    }
    /**
     * Searchable mailboxes result
     */
    get DiscoverySearchConfigurations() {
        return this.configurations;
    }
    /**
     * @internal Reads response elements from Xml JsObject.
     *
     * @param   {any}               jsObject   The response object.
     * @param   {ExchangeService}   service    The service.
     */
    ReadElementsFromXmlJsObject(jsObject, service) {
        this.configurations.splice(0);
        //super.ReadElementsFromXmlJsObject(jsObject, service);
        if (jsObject[XmlElementNames_1.XmlElementNames.DiscoverySearchConfigurations]) {
            for (let searchConfiguration of EwsServiceJsonReader_1.EwsServiceJsonReader.ReadAsArray(jsObject[XmlElementNames_1.XmlElementNames.DiscoverySearchConfigurations], XmlElementNames_1.XmlElementNames.DiscoverySearchConfiguration)) {
                this.configurations.push(DiscoverySearchConfiguration_1.DiscoverySearchConfiguration.LoadFromXmlJsObject(searchConfiguration, service));
            }
        }
    }
}
exports.GetDiscoverySearchConfigurationResponse = GetDiscoverySearchConfigurationResponse;
//# sourceMappingURL=GetDiscoverySearchConfigurationResponse.js.map