"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetClientAccessTokenResponse = void 0;
const ClientAccessTokenType_1 = require("../../Enumerations/ClientAccessTokenType");
const ExtensionMethods_1 = require("../../ExtensionMethods");
const XmlElementNames_1 = require("../XmlElementNames");
const ServiceResponse_1 = require("./ServiceResponse");
/**
 * Represents the response to a GetClientAccessToken operation.
 *
 * @sealed
 */
class GetClientAccessTokenResponse extends ServiceResponse_1.ServiceResponse {
    constructor(id = null, tokenType = ClientAccessTokenType_1.ClientAccessTokenType.CallerIdentity) {
        super();
        this.TokenValue = null;
        this.TTL = 0;
        this.Id = id;
        this.TokenType = tokenType;
    }
    /**
     * @internal Reads response elements from Xml JsObject.
     *
     * @param   {any}               jsObject   The response object.
     * @param   {ExchangeService}   service    The service.
     */
    ReadElementsFromXmlJsObject(responseObject, service) {
        if (responseObject[XmlElementNames_1.XmlElementNames.Token]) {
            let jsObject = responseObject[XmlElementNames_1.XmlElementNames.Token];
            this.Id = jsObject[XmlElementNames_1.XmlElementNames.Id];
            this.TokenType = ClientAccessTokenType_1.ClientAccessTokenType[jsObject[XmlElementNames_1.XmlElementNames.TokenType]];
            this.TokenValue = jsObject[XmlElementNames_1.XmlElementNames.TokenValue];
            this.TTL = ExtensionMethods_1.Convert.toNumber(jsObject[XmlElementNames_1.XmlElementNames.TTL]);
        }
    }
}
exports.GetClientAccessTokenResponse = GetClientAccessTokenResponse;
//# sourceMappingURL=GetClientAccessTokenResponse.js.map