"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetAttachmentResponse = void 0;
const FileAttachment_1 = require("../../ComplexProperties/FileAttachment");
const ItemAttachment_1 = require("../../ComplexProperties/ItemAttachment");
const XmlElementNames_1 = require("../XmlElementNames");
const ServiceResponse_1 = require("./ServiceResponse");
/**
 * Represents the response to an individual attachment retrieval request.
 */
class GetAttachmentResponse extends ServiceResponse_1.ServiceResponse {
    /**
     * @internal Initializes a new instance of the **GetAttachmentResponse** class.
     *
     * @param   {Attachment}   attachment   The attachment.
     */
    constructor(attachment) {
        super();
        this.attachment = null;
        this.attachment = attachment;
    }
    get Attachment() {
        return this.attachment;
    }
    /**
     * @internal Reads response elements from XMLJsObject.
     *
     * @param   {any}               jsObject   The response object.
     * @param   {ExchangeService}   service          The service.
     */
    ReadElementsFromXmlJsObject(jsObject, service) {
        if (jsObject[XmlElementNames_1.XmlElementNames.Attachments]) {
            let attachmentContainer = jsObject[XmlElementNames_1.XmlElementNames.Attachments];
            let attachment = attachmentContainer[XmlElementNames_1.XmlElementNames.FileAttachment] || attachmentContainer[XmlElementNames_1.XmlElementNames.ItemAttachment] || attachmentContainer;
            if (this.attachment == null) {
                if (attachmentContainer[XmlElementNames_1.XmlElementNames.FileAttachment]) {
                    this.attachment = new FileAttachment_1.FileAttachment(service);
                }
                else if (attachmentContainer[XmlElementNames_1.XmlElementNames.ItemAttachment]) {
                    this.attachment = new ItemAttachment_1.ItemAttachment(service);
                }
            }
            if (this.attachment != null) {
                this.attachment.LoadFromXmlJsObject(attachment, service);
            }
        }
    }
}
exports.GetAttachmentResponse = GetAttachmentResponse;
//# sourceMappingURL=GetAttachmentResponse.js.map