"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateItemResponseBase = void 0;
const EwsServiceJsonReader_1 = require("../EwsServiceJsonReader");
const XmlElementNames_1 = require("../XmlElementNames");
const ServiceResponse_1 = require("./ServiceResponse");
class CreateItemResponseBase extends ServiceResponse_1.ServiceResponse {
    get Items() {
        return this.items;
    }
    GetObjectInstance(service, xmlElementName) { throw new Error("CreateItemResponseBase.ts - GetObjectInstance : abstract must implement."); }
    ReadElementsFromJson(responseObject, service) { throw new Error("CreateItemResponseBase.ts - ReadElementsFromJson : Not implemented."); }
    ReadElementsFromXmlJsObject(responseObject, service) {
        if (responseObject[XmlElementNames_1.XmlElementNames.Items]) {
            this.items = EwsServiceJsonReader_1.EwsServiceJsonReader.ReadServiceObjectsCollectionFromJson(responseObject, service, XmlElementNames_1.XmlElementNames.Items, this.GetObjectInstance.bind(this), false, /* clearPropertyBag */ null, /* requestedPropertySet */ false); /* summaryPropertiesOnly */
        }
    }
}
exports.CreateItemResponseBase = CreateItemResponseBase;
//# sourceMappingURL=CreateItemResponseBase.js.map