"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateFolderResponse = void 0;
const FolderInfo_1 = require("../ServiceObjects/Folders/FolderInfo");
const XmlElementNames_1 = require("../XmlElementNames");
const EwsServiceJsonReader_1 = require("../EwsServiceJsonReader");
const ServiceResult_1 = require("../../Enumerations/ServiceResult");
const ServiceResponse_1 = require("./ServiceResponse");
class CreateFolderResponse extends ServiceResponse_1.ServiceResponse {
    constructor(folder) {
        super();
        this.folder = null;
        this.folder = folder;
    }
    GetObjectInstance(service, xmlElementName) {
        if (this.folder != null) {
            return this.folder;
        }
        else {
            var flinfo = new FolderInfo_1.FolderInfo();
            return flinfo.CreateEwsObjectFromXmlElementName(service, xmlElementName);
        }
    }
    Loaded() {
        if (this.Result == ServiceResult_1.ServiceResult.Success) {
            this.folder.ClearChangeLog();
        }
    }
    ReadElementsFromJson(responseObject, service) { throw new Error("CreateFolderResponse.ts - ReadElementsFromJson : Not implemented."); }
    ReadElementsFromXmlJsObject(responseObject, service) {
        if (responseObject[XmlElementNames_1.XmlElementNames.Folders]) {
            var folders = EwsServiceJsonReader_1.EwsServiceJsonReader.ReadServiceObjectsCollectionFromJson(responseObject, service, XmlElementNames_1.XmlElementNames.Folders, this.GetObjectInstance.bind(this), false, /* clearPropertyBag */ null, /* requestedPropertySet */ false); /* summaryPropertiesOnly */
            this.folder = folders[0];
        }
    }
}
exports.CreateFolderResponse = CreateFolderResponse;
//# sourceMappingURL=CreateFolderResponse.js.map