"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateAttachmentResponse = void 0;
const EwsServiceJsonReader_1 = require("../EwsServiceJsonReader");
const EwsLogging_1 = require("../EwsLogging");
const ServiceResponse_1 = require("./ServiceResponse");
const XmlElementNames_1 = require("../XmlElementNames");
/**
 * Represents the response to an individual attachment creation operation.
 * @sealed
 */
class CreateAttachmentResponse extends ServiceResponse_1.ServiceResponse {
    /**
     * Initializes a new instance of the **CreateAttachmentResponse** class.
     *
     * @param   {Attachment}   attachment   The attachment.
     */
    constructor(attachment) {
        super();
        this.attachment = null;
        EwsLogging_1.EwsLogging.Assert(attachment != null, "CreateAttachmentResponse.ctor", "attachment is null");
        this.attachment = attachment;
    }
    /**
     * Gets the attachment that was created.
     */
    get Attachment() {
        return this.attachment;
    }
    /**
      * @internal Reads response elements from Xml JsObject.
      *
      * @param   {any}               jsObject   The response object.
      * @param   {ExchangeService}   service    The service.
      */
    ReadElementsFromXmlJsObject(responseObject, service) {
        let attachmentArray = EwsServiceJsonReader_1.EwsServiceJsonReader.ReadAsArray(responseObject, XmlElementNames_1.XmlElementNames.Attachments);
        if (attachmentArray != null && attachmentArray.length > 0) {
            let attachmenTypetArray = EwsServiceJsonReader_1.EwsServiceJsonReader.ReadAsArray(attachmentArray[0], XmlElementNames_1.XmlElementNames.ItemAttachment);
            if (attachmenTypetArray.length > 0) {
                this.attachment.LoadFromXmlJsObject(attachmenTypetArray[0], service);
                return;
            }
            attachmenTypetArray = EwsServiceJsonReader_1.EwsServiceJsonReader.ReadAsArray(attachmentArray[0], XmlElementNames_1.XmlElementNames.FileAttachment);
            if (attachmenTypetArray.length > 0) {
                this.attachment.LoadFromXmlJsObject(attachmenTypetArray[0], service);
            }
        }
    }
}
exports.CreateAttachmentResponse = CreateAttachmentResponse;
//# sourceMappingURL=CreateAttachmentResponse.js.map