"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UninstallAppRequest = void 0;
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const UninstallAppResponse_1 = require("../Responses/UninstallAppResponse");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const SimpleServiceRequestBase_1 = require("./SimpleServiceRequestBase");
/**
 * @internal  Represents a UninstallApp request.
 *
 * @sealed
 */
class UninstallAppRequest extends SimpleServiceRequestBase_1.SimpleServiceRequestBase {
    /**
     * @internal Initializes a new instance of the **UninstallAppRequest** class.
     *
     * @param   {ExchangeService}   service   The service.
     * @param   {string}   			id        Extension ID
     */
    constructor(service, id) {
        super(service);
        /**
         * Extension ID
         */
        this.ID = null;
        this.ID = id;
    }
    /**
     * @internal Executes this request.
     *
     * @return  {Promise<UninstallAppResponse>}      Service response  :Promise.
     */
    Execute() {
        return this.InternalExecute().then((serviceResponse) => {
            serviceResponse.ThrowIfNecessary();
            return serviceResponse;
        });
    }
    /**
     * @internal Gets the request version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this request is supported.
     */
    GetMinimumRequiredServerVersion() {
        return ExchangeVersion_1.ExchangeVersion.Exchange2013;
    }
    /**
     * @internal Gets the name of the response XML element.
     *
     * @return  {string}      XML element name.
     */
    GetResponseXmlElementName() {
        return XmlElementNames_1.XmlElementNames.UninstallAppResponse;
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name.
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.UninstallAppRequest;
    }
    /**
     * @internal Parses the response.
     *
     * @param   {any}   jsonBody   The js object response body.
     * @return  {any}              Response object.
     */
    ParseResponse(jsonBody) {
        let response = new UninstallAppResponse_1.UninstallAppResponse();
        response.LoadFromXmlJsObject(jsonBody, this.Service);
        return response;
    }
    /**
     * @internal Writes the elements to XML writer.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.ID, this.ID);
    }
}
exports.UninstallAppRequest = UninstallAppRequest;
//# sourceMappingURL=UninstallAppRequest.js.map