"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubscribeToStreamingNotificationsRequest = void 0;
const ArgumentException_1 = require("../../Exceptions/ArgumentException");
const ExtensionMethods_1 = require("../../ExtensionMethods");
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const SubscribeResponse_1 = require("../Responses/SubscribeResponse");
const XmlElementNames_1 = require("../XmlElementNames");
const StreamingSubscription_1 = require("../../Notifications/StreamingSubscription");
const SubscribeRequest_1 = require("./SubscribeRequest");
/**
 * @internal Represents a *Streaming* Subscribe request.
 */
class SubscribeToStreamingNotificationsRequest extends SubscribeRequest_1.SubscribeRequest {
    /**
     * @internal Initializes a new instance of the **SubscribeToStreamingNotificationsRequest** class.
     *
     * @param   {ExchangeService}   service   The service.
     */
    constructor(service) {
        super(service);
    }
    /**
     * @internal Creates service response.
     *
     * @param   {ExchangeService}   service         The service.
     * @param   {number}   			responseIndex   Index of the response.
     * @return  {SubscribeResponse<StreamingSubscription>}	Service response.
     */
    CreateServiceResponse(service, responseIndex) {
        return new SubscribeResponse_1.SubscribeResponse(new StreamingSubscription_1.StreamingSubscription(service));
    }
    /**
     * @internal Gets the request version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this request is supported.
     */
    GetMinimumRequiredServerVersion() { return ExchangeVersion_1.ExchangeVersion.Exchange2010_SP1; }
    /**
     * @internal Gets the name of the subscription XML element.
     *
     * @return  {string}      XML element name,
     */
    GetSubscriptionXmlElementName() { return XmlElementNames_1.XmlElementNames.StreamingSubscriptionRequest; }
    /**
     * @internal Internal method to write XML elements.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    InternalWriteElementsToXml(writer) {
    }
    /**
     * @internal Validate request.
     */
    Validate() {
        super.Validate();
        if (!ExtensionMethods_1.StringHelper.IsNullOrEmpty(this.Watermark)) {
            throw new ArgumentException_1.ArgumentException("Watermarks cannot be used with StreamingSubscriptions.", "Watermark");
        }
    }
}
exports.SubscribeToStreamingNotificationsRequest = SubscribeToStreamingNotificationsRequest;
//# sourceMappingURL=SubscribeToStreamingNotificationsRequest.js.map