"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RemoveDelegateRequest = void 0;
const EwsUtilities_1 = require("../EwsUtilities");
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const DelegateManagementResponse_1 = require("../Responses/DelegateManagementResponse");
const DelegateManagementRequestBase_1 = require("./DelegateManagementRequestBase");
/**
 * @internal Represents a RemoveDelete request.
 */
class RemoveDelegateRequest extends DelegateManagementRequestBase_1.DelegateManagementRequestBase {
    /**
     * @internal Initializes a new instance of the **RemoveDelegateRequest** class.
     *
     * @param   {ExchangeService}   service   The service.
     */
    constructor(service) {
        super(service);
        this.userIds = [];
    }
    /**
     * Gets the user ids.
     *
     * @value   The user ids.
     */
    get UserIds() {
        return this.userIds;
    }
    /**
     * @internal Creates the response
     *
     * @return  {DelegateManagementResponse}		Response object.
     */
    CreateResponse() {
        return new DelegateManagementResponse_1.DelegateManagementResponse(false, null);
    }
    /**
     * @internal Gets the request version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this request is supported.
     */
    GetMinimumRequiredServerVersion() {
        return ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1;
    }
    /**
     * @internal Gets the name of the response XML element.
     *
     * @return  {string}      XML element name,
     */
    GetResponseXmlElementName() {
        return XmlElementNames_1.XmlElementNames.RemoveDelegateResponse;
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name,
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.RemoveDelegate;
    }
    /**
     * @internal Validate request.
     */
    Validate() {
        super.Validate();
        EwsUtilities_1.EwsUtilities.ValidateParamCollection(this.UserIds, "UserIds");
    }
    /**
     * @internal Writes XML elements.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        super.WriteElementsToXml(writer);
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.UserIds);
        for (let userId of this.UserIds) {
            userId.WriteToXml(writer, XmlElementNames_1.XmlElementNames.UserId);
        }
        writer.WriteEndElement(); // UserIds
    }
}
exports.RemoveDelegateRequest = RemoveDelegateRequest;
//# sourceMappingURL=RemoveDelegateRequest.js.map