"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MultiResponseServiceRequest = void 0;
const ServiceJsonDeserializationException_1 = require("../../Exceptions/ServiceJsonDeserializationException");
const Strings_1 = require("../../Strings");
const EwsLogging_1 = require("../EwsLogging");
const EwsServiceJsonReader_1 = require("../EwsServiceJsonReader");
const XmlElementNames_1 = require("../XmlElementNames");
const ServiceResult_1 = require("../../Enumerations/ServiceResult");
const ServiceErrorHandling_1 = require("../../Enumerations/ServiceErrorHandling");
const ServiceResponseCollection_1 = require("../Responses/ServiceResponseCollection");
const ServiceResponseException_1 = require("../../Exceptions/ServiceResponseException");
const ServiceXmlDeserializationException_1 = require("../../Exceptions/ServiceXmlDeserializationException");
const RenderingMode_1 = require("../../Enumerations/RenderingMode");
const ExtensionMethods_1 = require("../../ExtensionMethods");
const SimpleServiceRequestBase_1 = require("./SimpleServiceRequestBase");
/** @internal */
class MultiResponseServiceRequest extends SimpleServiceRequestBase_1.SimpleServiceRequestBase {
    constructor(service, errorHandlingMode) {
        super(service);
        this.errorHandlingMode = errorHandlingMode;
    }
    get ErrorHandlingMode() { return this.errorHandlingMode; }
    CreateServiceResponse(service, responseIndex) { throw new Error("abstract; must implemented."); }
    //EndExecute(asyncResult: any/*System.IAsyncResult*/): ServiceResponseCollection<TResponse> { throw new Error("MultiResponseServiceRequest.ts - EndExecute : Not implemented."); }
    Execute() {
        return new Promise((successDelegate, errorDelegate) => {
            this.InternalExecute().then((value) => {
                var serviceResponses = value;
                if (this.ErrorHandlingMode == ServiceErrorHandling_1.ServiceErrorHandling.ThrowOnError) {
                    EwsLogging_1.EwsLogging.Assert(serviceResponses.Count == 1, "MultiResponseServiceRequest.Execute", "ServiceErrorHandling.ThrowOnError error handling is only valid for singleton request");
                    try {
                        serviceResponses.__thisIndexer(0).ThrowIfNecessary();
                    }
                    catch (error) {
                        if (errorDelegate) {
                            errorDelegate(error);
                        }
                    }
                }
                //return serviceResponses; //no return succedssdelegates take care of returning
                if (successDelegate) {
                    successDelegate(serviceResponses);
                }
            }, (resperr) => {
                //debugger;
                if (errorDelegate) {
                    errorDelegate(resperr);
                }
            });
        });
    }
    GetExpectedResponseMessageCount() { throw new Error("Abstract; must implemented."); }
    GetResponseMessageXmlElementName() { throw new Error("Abstract; must implemented."); }
    ParseResponseXMLJsObject(jsObject) {
        var serviceResponses = new ServiceResponseCollection_1.ServiceResponseCollection();
        //set context to XmlElementNames.ResponseMessages
        //todo: this can have multiple reponse messages.
        var jsResponseMessages = jsObject[XmlElementNames_1.XmlElementNames.ResponseMessages];
        // if (!Array.isArray(jsResponseMessages)) {
        //     jsResponseMessages = [jsResponseMessages];
        // }
        var responseMessageXmlElementName = this.GetResponseMessageXmlElementName();
        let responseMessages = EwsServiceJsonReader_1.EwsServiceJsonReader.ReadAsArray(jsResponseMessages, responseMessageXmlElementName);
        //for (var i = 0; i < responses.length; i++) {
        for (var i = 0; i < this.GetExpectedResponseMessageCount(); i++) {
            var response = this.CreateServiceResponse(this.Service, i);
            //ref: check need for responseMessageXmlElementName
            var jsResponseMessage = responseMessages[i];
            response.LoadFromXmlJsObject(jsResponseMessage, this.Service); //, responseMessageXmlElementName, this.Service);
            // Add the response to the list after it has been deserialized because the response
            // list updates an overall result as individual responses are added to it.
            serviceResponses.Add(response);
        }
        // If there's a general error in batch processing,
        // the server will return a single response message containing the error
        // (for example, if the SavedItemFolderId is bogus in a batch CreateItem
        // call). In this case, throw a ServiceResponsException. Otherwise this
        // is an unexpected server error.
        if (serviceResponses.Count < this.GetExpectedResponseMessageCount()) {
            if ((serviceResponses.Count >= 1) && (serviceResponses.__thisIndexer(0).Result == ServiceResult_1.ServiceResult.Error)) {
                throw new ServiceResponseException_1.ServiceResponseException(serviceResponses.__thisIndexer(0));
            }
            else {
                throw new ServiceXmlDeserializationException_1.ServiceXmlDeserializationException(ExtensionMethods_1.StringHelper.Format(Strings_1.Strings.TooFewServiceReponsesReturned, this.GetResponseMessageXmlElementName(), this.GetExpectedResponseMessageCount(), serviceResponses.Count));
            }
        }
        return serviceResponses;
    }
    ParseResponse(jsonBody) {
        if (this.Service.RenderingMethod === RenderingMode_1.RenderingMode.JSON) {
            throw new Error("not implemented");
            var serviceResponses = new ServiceResponseCollection_1.ServiceResponseCollection();
            var jsonResponseMessages = jsonBody[XmlElementNames_1.XmlElementNames.ResponseMessages][XmlElementNames_1.XmlElementNames.Items];
            var responseCtr = 0;
            for (var jsonResponseObject of jsonResponseMessages) {
                var response = this.CreateServiceResponse(this.Service, responseCtr);
                response.LoadFromXmlJsObject(jsonResponseObject, this.Service);
                // Add the response to the list after it has been deserialized because the response
                // list updates an overall result as individual responses are added to it.
                serviceResponses.Add(response);
                responseCtr++;
            }
            if (serviceResponses.Count < this.GetExpectedResponseMessageCount()) {
                if ((serviceResponses.Count == 1) && (serviceResponses[0].Result == ServiceResult_1.ServiceResult.Error)) {
                    throw new ServiceResponseException_1.ServiceResponseException(serviceResponses[0]);
                }
                else {
                    throw new ServiceJsonDeserializationException_1.ServiceJsonDeserializationException();
                }
            }
            return serviceResponses;
        }
        else {
            return this.ParseResponseXMLJsObject(jsonBody);
        }
    }
}
exports.MultiResponseServiceRequest = MultiResponseServiceRequest;
//# sourceMappingURL=MultiResponseServiceRequest.js.map