"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MoveCopyItemRequest = void 0;
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const ItemIdWrapperList_1 = require("../../Misc/ItemIdWrapperList");
const MoveCopyRequest_1 = require("./MoveCopyRequest");
/** @internal */
class MoveCopyItemRequest extends MoveCopyRequest_1.MoveCopyRequest {
    constructor(service, errorHandlingModeServiceErrorHandling) {
        super(service, errorHandlingModeServiceErrorHandling);
        this.ReturnNewItemIds = null; //nullable
        this.itemIds = new ItemIdWrapperList_1.ItemIdWrapperList();
    }
    get ItemIds() { return this.itemIds; }
    //AddIdsToJson(jsonObject: any, service: ExchangeService): any { throw new Error("MoveCopyItemRequest.ts - AddIdsToJson : Not implemented."); }
    GetExpectedResponseMessageCount() { return this.ItemIds.Count; }
    Validate() {
        super.Validate();
        //EwsUtilities.ValidateParam(this.ItemIds, "ItemIds");
    }
    /**@internal */
    WriteIdsToXml(writer) {
        this.ItemIds.WriteToXml(writer, XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.ItemIds);
        if (this.ReturnNewItemIds) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.ReturnNewItemIds, this.ReturnNewItemIds);
        }
    }
}
exports.MoveCopyItemRequest = MoveCopyItemRequest;
//# sourceMappingURL=MoveCopyItemRequest.js.map