"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MarkAllItemsAsReadRequest = void 0;
const FolderIdWrapperList_1 = require("../../Misc/FolderIdWrapperList");
const ServiceResponse_1 = require("../Responses/ServiceResponse");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const MultiResponseServiceRequest_1 = require("./MultiResponseServiceRequest");
/** @internal */
class MarkAllItemsAsReadRequest extends MultiResponseServiceRequest_1.MultiResponseServiceRequest {
    constructor(service, errorHandlingMode) {
        super(service, errorHandlingMode);
        this.folderIds = new FolderIdWrapperList_1.FolderIdWrapperList();
        this.ReadFlag = false;
        this.SuppressReadReceipts = false;
    }
    get FolderIds() {
        return this.folderIds;
    }
    CreateServiceResponse(service, responseIndex) { return new ServiceResponse_1.ServiceResponse(); }
    GetExpectedResponseMessageCount() { return this.FolderIds.Count; }
    GetMinimumRequiredServerVersion() { return ExchangeVersion_1.ExchangeVersion.Exchange2013; }
    GetResponseMessageXmlElementName() { return XmlElementNames_1.XmlElementNames.MarkAllItemsAsReadResponseMessage; }
    GetResponseXmlElementName() { return XmlElementNames_1.XmlElementNames.MarkAllItemsAsReadResponse; }
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.MarkAllItemsAsRead; }
    Validate() {
        super.Validate();
        //EwsUtilities.ValidateParam(this.FolderIds, "FolderIds");
        this.FolderIds.Validate(this.Service.RequestedServerVersion);
    }
    /**@internal */
    WriteElementsToXml(writer) {
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.ReadFlag, this.ReadFlag);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.SuppressReadReceipts, this.SuppressReadReceipts);
        this.FolderIds.WriteToXml(writer, XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.FolderIds);
    }
}
exports.MarkAllItemsAsReadRequest = MarkAllItemsAsReadRequest;
//# sourceMappingURL=MarkAllItemsAsReadRequest.js.map