"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstallAppRequest = void 0;
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const InstallAppResponse_1 = require("../Responses/InstallAppResponse");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const SimpleServiceRequestBase_1 = require("./SimpleServiceRequestBase");
/**
 * @internal Represents a InstallApp request.
 *
 * @sealed
 */
class InstallAppRequest extends SimpleServiceRequestBase_1.SimpleServiceRequestBase {
    /**
     * Initializes a new instance of the **InstallAppRequest** class.
     *
     * @param   {ExchangeService}   service          The service.
     * @param   {string}   			manifestStream   The manifest's plain text XML stream.
     */
    constructor(service, manifestStream) {
        super(service);
        /**
         * The plain text manifest stream as base64 encoded string.
         */
        this.manifestStream = null;
        this.manifestStream = manifestStream;
    }
    /**
     * @internal Executes this request.
     *
     * @return  {Promise<InstallAppResponse>}      Service response  :Promise.
     */
    Execute() {
        return this.InternalExecute().then((serviceResponse) => {
            serviceResponse.ThrowIfNecessary();
            return serviceResponse;
        });
    }
    /**
     * @internal Gets the request version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this request is supported.
     */
    GetMinimumRequiredServerVersion() {
        return ExchangeVersion_1.ExchangeVersion.Exchange2013;
    }
    /**
     * @internal Gets the name of the response XML element.
     *
     * @return  {string}      XML element name.
     */
    GetResponseXmlElementName() {
        return XmlElementNames_1.XmlElementNames.InstallAppResponse;
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name.
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.InstallAppRequest;
    }
    /**
     * @internal Parses the response.
     *
     * @param   {any}   jsonBody   The js object response body.
     * @return  {any}              Response object.
     */
    ParseResponse(jsonBody) {
        let response = new InstallAppResponse_1.InstallAppResponse();
        response.LoadFromXmlJsObject(jsonBody, this.Service);
        return response;
    }
    /**
     * @internal Writes the elements to XML writer.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.Manifest);
        //writer.WriteBase64ElementValue(manifestStream);
        writer.WriteValue(this.manifestStream, null);
        writer.WriteEndElement();
    }
}
exports.InstallAppRequest = InstallAppRequest;
//# sourceMappingURL=InstallAppRequest.js.map