"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetUserOofSettingsRequest = void 0;
const EwsUtilities_1 = require("../EwsUtilities");
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const GetUserOofSettingsResponse_1 = require("../Responses/GetUserOofSettingsResponse");
const OofExternalAudience_1 = require("../../Enumerations/OofExternalAudience");
const OofSettings_1 = require("../../ComplexProperties/Availability/OofSettings");
const ServiceError_1 = require("../../Enumerations/ServiceError");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const SimpleServiceRequestBase_1 = require("./SimpleServiceRequestBase");
/**
 * @internal Represents a GetUserOofSettings request.
 *
 * @sealed
 */
class GetUserOofSettingsRequest extends SimpleServiceRequestBase_1.SimpleServiceRequestBase {
    /**
     * @internal Initializes a new instance of the **GetUserOofSettingsRequest** class.
     *
     * @param   {ExchangeService}   service   The service.
     */
    constructor(service) {
        super(service);
        this.smtpAddress = null;
    }
    /**
     * @internal Gets or sets the SMTP address.
     */
    get SmtpAddress() {
        return this.smtpAddress;
    }
    set SmtpAddress(value) {
        this.smtpAddress = value;
    }
    /**
     * @internal Executes this request.
     *
     * @return  {Promise<GetUserOofSettingsResponse>}      Service response.
     */
    Execute() {
        return this.InternalExecute().then((serviceResponse) => {
            serviceResponse.ThrowIfNecessary();
            return serviceResponse;
        });
    }
    /**
     * @internal Gets the request version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this request is supported.
     */
    GetMinimumRequiredServerVersion() { return ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1; }
    /**
     * @internal Gets the name of the response XML element.
     *
     * @return  {string}      XML element name,
     */
    GetResponseXmlElementName() { return XmlElementNames_1.XmlElementNames.GetUserOofSettingsResponse; }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name,
     */
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.GetUserOofSettingsRequest; }
    /**
     * Parses the response.
     *
     * @param   {any}   jsObjectBody   The jsObjectBody from XmlJsObject.
     * @return  {any}            Response object.
     */
    ParseResponse(jsObjectBody) {
        var serviceResponse = new GetUserOofSettingsResponse_1.GetUserOofSettingsResponse();
        serviceResponse.LoadFromXmlJsObject(jsObjectBody[XmlElementNames_1.XmlElementNames.ResponseMessage], this.Service);
        if (serviceResponse.ErrorCode == ServiceError_1.ServiceError.NoError) {
            if (jsObjectBody[XmlElementNames_1.XmlElementNames.OofSettings]) {
                serviceResponse.OofSettings = new OofSettings_1.OofSettings();
                serviceResponse.OofSettings.LoadFromXmlJsObject(jsObjectBody[XmlElementNames_1.XmlElementNames.OofSettings], this.Service);
                serviceResponse.OofSettings.AllowExternalOof = OofExternalAudience_1.OofExternalAudience[jsObjectBody[XmlElementNames_1.XmlElementNames.AllowExternalOof]];
            }
        }
        return serviceResponse;
    }
    /**
     * @internal Validate request.
     */
    Validate() {
        super.Validate();
        EwsUtilities_1.EwsUtilities.ValidateParam(this.SmtpAddress, "SmtpAddress");
    }
    /**
     * @internal Writes XML elements.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.Mailbox);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.Address, this.SmtpAddress);
        writer.WriteEndElement(); // Mailbox
    }
}
exports.GetUserOofSettingsRequest = GetUserOofSettingsRequest;
//# sourceMappingURL=GetUserOofSettingsRequest.js.map