"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetServerTimeZonesRequest = void 0;
const EwsUtilities_1 = require("../EwsUtilities");
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const ServiceErrorHandling_1 = require("../../Enumerations/ServiceErrorHandling");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const GetServerTimeZonesResponse_1 = require("../Responses/GetServerTimeZonesResponse");
const MultiResponseServiceRequest_1 = require("./MultiResponseServiceRequest");
/**
 * @internal Represents a GetServerTimeZones request.
 */
class GetServerTimeZonesRequest extends MultiResponseServiceRequest_1.MultiResponseServiceRequest {
    /**
     * @internal Initializes a new instance of the **GetServerTimeZonesRequest** class.
     *
     * @param   {service}   service   The service.
     */
    constructor(service) {
        super(service, ServiceErrorHandling_1.ServiceErrorHandling.ThrowOnError);
    }
    /**
     * @internal Gets or sets the ids of the time zones that should be returned by the server.
     */
    get Ids() {
        return this.ids;
    }
    set Ids(value) {
        this.ids = value;
    }
    /**
     * @internal Creates the service response.
     *
     * @param   {ExchangeService}   service         The service.
     * @param   {number}   			responseIndex   Index of the response.
     * @return  {SyncFolderItemsResponse}		Response object.
     */
    CreateServiceResponse(service, responseIndex) {
        return new GetServerTimeZonesResponse_1.GetServerTimeZonesResponse();
    }
    /**
     * @internal Gets the expected response message count.
     *
     * @return  {number}      Number of items in response.
     */
    GetExpectedResponseMessageCount() {
        return 1;
    }
    /**
     * @internal Gets the request version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this request is supported.
     */
    GetMinimumRequiredServerVersion() {
        return ExchangeVersion_1.ExchangeVersion.Exchange2010;
    }
    /**
     * @internal Gets the name of the response message XML element.
     *
     * @return  {string}      XML element name.
     */
    GetResponseMessageXmlElementName() {
        return XmlElementNames_1.XmlElementNames.GetServerTimeZonesResponseMessage;
    }
    /**
     * @internal Gets the name of the response XML element.
     *
     * @return  {string}      XML element name.
     */
    GetResponseXmlElementName() {
        return XmlElementNames_1.XmlElementNames.GetServerTimeZonesResponse;
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name.
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.GetServerTimeZones;
    }
    /**
     * @internal Validate request.
     */
    Validate() {
        super.Validate();
        if (this.ids != null) {
            EwsUtilities_1.EwsUtilities.ValidateParamCollection(this.ids, "Ids");
        }
    }
    /**
     * @internal Writes the elements to XML writer.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        if (this.Ids != null) {
            writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.Ids);
            for (let id of this.ids) {
                writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.Id, id);
            }
            writer.WriteEndElement(); // Ids
        }
    }
}
exports.GetServerTimeZonesRequest = GetServerTimeZonesRequest;
//# sourceMappingURL=GetServerTimeZonesRequest.js.map