"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetRoomListsRequest = void 0;
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const GetRoomListsResponse_1 = require("../Responses/GetRoomListsResponse");
const XmlElementNames_1 = require("../XmlElementNames");
const SimpleServiceRequestBase_1 = require("./SimpleServiceRequestBase");
/**
 * @internal Represents a GetRoomList request.
 *
 * @sealed
 */
class GetRoomListsRequest extends SimpleServiceRequestBase_1.SimpleServiceRequestBase {
    /**
     * @internal Initializes a new instance of the **GetRoomListsRequest** class.
     *
     * @param   {service}   service   The service.
     */
    constructor(service) {
        super(service);
    }
    /**
     * @internal Executes this request.
     *
     * @return  {Promise<GetRoomListsResponse>}      Service response  :Promise.
     */
    Execute() {
        return this.InternalExecute().then((serviceResponse) => {
            serviceResponse.ThrowIfNecessary();
            return serviceResponse;
        });
    }
    /**
     * @internal Gets the request version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this request is supported.
     */
    GetMinimumRequiredServerVersion() {
        return ExchangeVersion_1.ExchangeVersion.Exchange2010;
    }
    /**
     * @internal Gets the name of the response XML element.
     *
     * @return  {string}      XML element name.
     */
    GetResponseXmlElementName() {
        return XmlElementNames_1.XmlElementNames.GetRoomListsResponse;
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name.
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.GetRoomListsRequest;
    }
    /**
     * @internal Parses the response.
     *
     * @param   {any}   jsonBody   The js object response body.
     * @return  {any}              Response object.
     */
    ParseResponse(jsonBody) {
        let response = new GetRoomListsResponse_1.GetRoomListsResponse();
        response.LoadFromXmlJsObject(jsonBody, this.Service);
        return response;
    }
    /**
     * @internal Writes the elements to XML writer.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        // Don't have parameter in request
    }
}
exports.GetRoomListsRequest = GetRoomListsRequest;
//# sourceMappingURL=GetRoomListsRequest.js.map