"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetPasswordExpirationDateRequest = void 0;
const GetPasswordExpirationDateResponse_1 = require("../Responses/GetPasswordExpirationDateResponse");
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const XmlElementNames_1 = require("../XmlElementNames");
const SimpleServiceRequestBase_1 = require("./SimpleServiceRequestBase");
/** @internal */
class GetPasswordExpirationDateRequest extends SimpleServiceRequestBase_1.SimpleServiceRequestBase {
    constructor(service) {
        super(service);
        this.mailboxSmtpAddress = null;
    }
    get MailboxSmtpAddress() {
        return this.mailboxSmtpAddress;
    }
    set MailboxSmtpAddress(value) {
        this.mailboxSmtpAddress = value;
    }
    Execute() {
        return this.InternalExecute().then((serviceResponse) => {
            serviceResponse.ThrowIfNecessary();
            return serviceResponse;
        });
    }
    GetMinimumRequiredServerVersion() { return ExchangeVersion_1.ExchangeVersion.Exchange2010_SP1; }
    GetResponseXmlElementName() { return XmlElementNames_1.XmlElementNames.GetPasswordExpirationDateResponse; }
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.GetPasswordExpirationDateRequest; }
    //ParseResponse(reader: any): any { throw new Error("GetPasswordExpirationDateRequest.ts - ParseResponse : Not implemented."); }
    ParseResponse(jsonBody) {
        var serviceResponse = new GetPasswordExpirationDateResponse_1.GetPasswordExpirationDateResponse();
        serviceResponse.LoadFromXmlJsObject(jsonBody, this.Service);
        return serviceResponse;
    }
    /**@internal */
    WriteElementsToXml(writer) { writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.MailboxSmtpAddress, this.MailboxSmtpAddress); }
}
exports.GetPasswordExpirationDateRequest = GetPasswordExpirationDateRequest;
//# sourceMappingURL=GetPasswordExpirationDateRequest.js.map