"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetNonIndexableItemDetailsRequest = void 0;
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const GetNonIndexableItemDetailsResponse_1 = require("../Responses/GetNonIndexableItemDetailsResponse");
const SearchPageDirection_1 = require("../../Enumerations/SearchPageDirection");
const ServiceValidationException_1 = require("../../Exceptions/ServiceValidationException");
const ExtensionMethods_1 = require("../../ExtensionMethods");
const Strings_1 = require("../../Strings");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const SimpleServiceRequestBase_1 = require("./SimpleServiceRequestBase");
/**
 * @internal Represents a GetNonIndexableItemDetailsRequest request.
 *
 * @sealed
 */
class GetNonIndexableItemDetailsRequest extends SimpleServiceRequestBase_1.SimpleServiceRequestBase {
    /**
     * @internal Initializes a new instance of the **GetNonIndexableItemDetailsRequest** class.
     *
     * @param   {ExchangeService}   service   The service.
     */
    constructor(service) {
        super(service);
        /**
         * Mailboxes
         */
        this.Mailboxes = null;
        /**
         * @Nullable Page size
         */
        this.PageSize = null;
        /**
         * Page item reference
         */
        this.PageItemReference = null;
        /**
         * @Nullable Page direction
         */
        this.PageDirection = null;
        /**
         * Whether to search archive only
         */
        this.SearchArchiveOnly = false;
    }
    /**
     * @internal Executes this request.
     *
     * @return  {Promise<GetNonIndexableItemDetailsResponse>}      Service response  :Promise.
     */
    Execute() {
        return this.InternalExecute().then((serviceResponse) => {
            return serviceResponse;
        });
    }
    /**
     * @internal Gets the request version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this request is supported.
     */
    GetMinimumRequiredServerVersion() {
        return ExchangeVersion_1.ExchangeVersion.Exchange2013;
    }
    /**
     * @internal Gets the name of the response XML element.
     *
     * @return  {string}      XML element name.
     */
    GetResponseXmlElementName() {
        return XmlElementNames_1.XmlElementNames.GetNonIndexableItemDetailsResponse;
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name.
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.GetNonIndexableItemDetails;
    }
    /**
     * @internal Parses the response.
     *
     * @param   {any}   jsonBody   The js object response body.
     * @return  {any}              Response object.
     */
    ParseResponse(jsonBody) {
        let response = new GetNonIndexableItemDetailsResponse_1.GetNonIndexableItemDetailsResponse();
        response.LoadFromXmlJsObject(jsonBody, this.Service);
        return response;
    }
    /**
     * @internal Validate request.
     */
    Validate() {
        super.Validate();
        if (this.Mailboxes == null || this.Mailboxes.length == 0) {
            throw new ServiceValidationException_1.ServiceValidationException(Strings_1.Strings.MailboxesParameterIsNotSpecified);
        }
    }
    /**
     * @internal Writes the elements to XML writer.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.Mailboxes);
        for (let mailbox of this.Mailboxes) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.LegacyDN, mailbox);
        }
        writer.WriteEndElement();
        if (this.PageSize) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.PageSize, this.PageSize);
        }
        if (!ExtensionMethods_1.StringHelper.IsNullOrEmpty(this.PageItemReference)) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.PageItemReference, this.PageItemReference);
        }
        if ((0, ExtensionMethods_1.hasValue)(this.PageDirection)) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.PageDirection, SearchPageDirection_1.SearchPageDirection[this.PageDirection]);
        }
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.SearchArchiveOnly, this.SearchArchiveOnly);
    }
}
exports.GetNonIndexableItemDetailsRequest = GetNonIndexableItemDetailsRequest;
//# sourceMappingURL=GetNonIndexableItemDetailsRequest.js.map