"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetItemRequestBase = void 0;
const Schemas_1 = require("../ServiceObjects/Schemas/Schemas");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const ItemIdWrapperList_1 = require("../../Misc/ItemIdWrapperList");
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const ServiceObjectType_1 = require("../../Enumerations/ServiceObjectType");
const GetRequest_1 = require("./GetRequest");
/** @internal */
class GetItemRequestBase extends GetRequest_1.GetRequest {
    constructor(service, errorHandlingMode) {
        super(service, errorHandlingMode);
        this.itemIds = new ItemIdWrapperList_1.ItemIdWrapperList();
    }
    get ItemIds() {
        return this.itemIds;
    }
    get EmitTimeZoneHeader() {
        // currently we do not emit "ItemResponseShapeType.IncludeMimeContent".
        //
        return this.PropertySet.Contains(Schemas_1.Schemas.ItemSchema.MimeContent);
    }
    //AddIdsToRequest(jsonRequest: any, service: ExchangeService): any { throw new Error("GetItemRequestBase.ts - AddIdsToRequest : Not implemented."); }
    GetExpectedResponseMessageCount() { return this.ItemIds.Count; }
    GetMinimumRequiredServerVersion() { return ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1; }
    GetResponseMessageXmlElementName() { return XmlElementNames_1.XmlElementNames.GetItemResponseMessage; }
    GetResponseXmlElementName() { return XmlElementNames_1.XmlElementNames.GetItemResponse; }
    GetServiceObjectType() { return ServiceObjectType_1.ServiceObjectType.Item; }
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.GetItem; }
    Validate() {
        super.Validate();
        //EwsUtilities.ValidateParamCollection(this.ItemIds, "ItemIds");
    }
    /**@internal */
    WriteElementsToXml(writer) {
        super.WriteElementsToXml(writer);
        this.ItemIds.WriteToXml(writer, XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.ItemIds);
    }
}
exports.GetItemRequestBase = GetItemRequestBase;
//# sourceMappingURL=GetItemRequestBase.js.map