"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetFolderRequestBase = void 0;
const ServiceObjectType_1 = require("../../Enumerations/ServiceObjectType");
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const FolderIdWrapperList_1 = require("../../Misc/FolderIdWrapperList");
const GetRequest_1 = require("./GetRequest");
/** @internal */
class GetFolderRequestBase extends GetRequest_1.GetRequest {
    constructor(service, errorHandlingModeServiceErrorHandling) {
        super(service, errorHandlingModeServiceErrorHandling);
        this.folderIds = new FolderIdWrapperList_1.FolderIdWrapperList();
    }
    get FolderIds() { return this.folderIds; }
    //AddIdsToRequest(jsonRequest: JsonObject, service: ExchangeService): any{ throw new Error("GetFolderRequestBase.ts - AddIdsToRequest : Not implemented.");}
    GetExpectedResponseMessageCount() { return this.FolderIds.Count; }
    GetMinimumRequiredServerVersion() { return ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1; }
    GetResponseMessageXmlElementName() { return XmlElementNames_1.XmlElementNames.GetFolderResponseMessage; }
    GetResponseXmlElementName() { return XmlElementNames_1.XmlElementNames.GetFolderResponse; }
    GetServiceObjectType() { return ServiceObjectType_1.ServiceObjectType.Folder; }
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.GetFolder; }
    Validate() {
        super.Validate();
        //EwsUtilities.ValidateParamCollection(this.FolderIds, "FolderIds");
        this.FolderIds.Validate(this.Service.RequestedServerVersion);
    }
    /**@internal */
    WriteElementsToXml(writer) {
        super.WriteElementsToXml(writer);
        this.FolderIds.WriteToXml(writer, XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.FolderIds);
    }
}
exports.GetFolderRequestBase = GetFolderRequestBase;
//# sourceMappingURL=GetFolderRequestBase.js.map