"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetDiscoverySearchConfigurationRequest = void 0;
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const GetDiscoverySearchConfigurationResponse_1 = require("../Responses/GetDiscoverySearchConfigurationResponse");
const ExtensionMethods_1 = require("../../ExtensionMethods");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const SimpleServiceRequestBase_1 = require("./SimpleServiceRequestBase");
/**
 * @internal Represents a GetDiscoverySearchConfigurationRequest.
 *
 * @sealed
 */
class GetDiscoverySearchConfigurationRequest extends SimpleServiceRequestBase_1.SimpleServiceRequestBase {
    /**
     * @internal Initializes a new instance of the **GetDiscoverySearchConfigurationRequest** class.
     *
     * @param   {ExchangeService}   service   The service.
     */
    constructor(service) {
        super(service);
        /**
         * Search Id
         */
        this.SearchId = null;
        /**
         * Expand group membership
         */
        this.ExpandGroupMembership = false;
        /**
         * In-Place hold configuration only
         */
        this.InPlaceHoldConfigurationOnly = false;
    }
    /**
     * @internal Executes this request.
     *
     * @return  {Promise<GetDiscoverySearchConfigurationResponse>}      Service response  :Promise.
     */
    Execute() {
        return this.InternalExecute().then((serviceResponse) => {
            return serviceResponse;
        });
    }
    /**
     * @internal Gets the request version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this request is supported.
     */
    GetMinimumRequiredServerVersion() {
        return ExchangeVersion_1.ExchangeVersion.Exchange2013;
    }
    /**
     * @internal Gets the name of the response XML element.
     *
     * @return  {string}      XML element name.
     */
    GetResponseXmlElementName() {
        return XmlElementNames_1.XmlElementNames.GetDiscoverySearchConfigurationResponse;
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name.
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.GetDiscoverySearchConfiguration;
    }
    /**
     * @internal Parses the response.
     *
     * @param   {any}   jsonBody   The js object response body.
     * @return  {any}              Response object.
     */
    ParseResponse(jsonBody) {
        let response = new GetDiscoverySearchConfigurationResponse_1.GetDiscoverySearchConfigurationResponse();
        response.LoadFromXmlJsObject(jsonBody, this.Service);
        return response;
    }
    /**
     * @internal Writes the elements to XML writer.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.SearchId, this.SearchId || ExtensionMethods_1.StringHelper.Empty);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.ExpandGroupMembership, this.ExpandGroupMembership);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.InPlaceHoldConfigurationOnly, this.InPlaceHoldConfigurationOnly);
    }
}
exports.GetDiscoverySearchConfigurationRequest = GetDiscoverySearchConfigurationRequest;
//# sourceMappingURL=GetDiscoverySearchConfigurationRequest.js.map