"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetDelegateRequest = void 0;
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const XmlAttributeNames_1 = require("../XmlAttributeNames");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const GetDelegateResponse_1 = require("../Responses/GetDelegateResponse");
const DelegateManagementRequestBase_1 = require("./DelegateManagementRequestBase");
/**
 * @internal Represents a GetDelegate request.
 */
class GetDelegateRequest extends DelegateManagementRequestBase_1.DelegateManagementRequestBase {
    /**
     * @internal Initializes a new instance of the **GetDelegateRequest** class.
     *
     * @param   {ExchangeService}   service   The service.
     */
    constructor(service) {
        super(service);
        this.userIds = [];
        this.includePermissions = false;
    }
    /**
     * Gets the user ids.
     *
     * @value   The user ids.
     */
    get UserIds() {
        return this.userIds;
    }
    /**
     * Gets or sets a value indicating whether permissions are included.
     */
    get IncludePermissions() {
        return this.includePermissions;
    }
    set IncludePermissions(value) {
        this.includePermissions = value;
    }
    /**
     * @internal Creates the response
     *
     * @return  {GetDelegateResponse}		Response object.
     */
    CreateResponse() {
        return new GetDelegateResponse_1.GetDelegateResponse(true);
    }
    /**
     * @internal Gets the request version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this request is supported.
     */
    GetMinimumRequiredServerVersion() {
        return ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1;
    }
    /**
     * @internal Gets the name of the response XML element.
     *
     * @return  {string}      XML element name,
     */
    GetResponseXmlElementName() {
        return XmlElementNames_1.XmlElementNames.GetDelegateResponse;
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name,
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.GetDelegate;
    }
    /**
     * @internal Writes XML attributes.
     *
     * /remarks/    Subclass will override if it has XML attributes.
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteAttributesToXml(writer) {
        super.WriteAttributesToXml(writer);
        writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.IncludePermissions, this.IncludePermissions);
    }
    /**
     * @internal Writes XML elements.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        super.WriteElementsToXml(writer);
        if (this.UserIds.length > 0) {
            writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.UserIds);
            for (let userId of this.UserIds) {
                userId.WriteToXml(writer, XmlElementNames_1.XmlElementNames.UserId);
            }
            writer.WriteEndElement(); // UserIds
        }
    }
}
exports.GetDelegateRequest = GetDelegateRequest;
//# sourceMappingURL=GetDelegateRequest.js.map