"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetClientAccessTokenRequest = void 0;
const ClientAccessTokenType_1 = require("../../Enumerations/ClientAccessTokenType");
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const GetClientAccessTokenResponse_1 = require("../Responses/GetClientAccessTokenResponse");
const ServiceValidationException_1 = require("../../Exceptions/ServiceValidationException");
const ExtensionMethods_1 = require("../../ExtensionMethods");
const Strings_1 = require("../../Strings");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const MultiResponseServiceRequest_1 = require("./MultiResponseServiceRequest");
/**
 * @internal Represents a GetClientAccessToken request.
 *
 * @sealed
 */
class GetClientAccessTokenRequest extends MultiResponseServiceRequest_1.MultiResponseServiceRequest {
    /**
     * @internal Initializes a new instance of the **GetClientAccessTokenRequest** class.
     *
     * @param   {ExchangeService}   	service             The service.
     * @param   {ServiceErrorHandling}  errorHandlingMode   Indicates how errors should be handled.
     */
    constructor(service, errorHandlingMode) {
        super(service, errorHandlingMode);
        this.TokenRequests = [];
    }
    /**
     * @internal Creates the service response.
     *
     * @param   {ExchangeService}   service         The service.
     * @param   {number}   			responseIndex   Index of the response.
     * @return  {GetClientAccessTokenResponse}		Response object.
     */
    CreateServiceResponse(service, responseIndex) {
        return new GetClientAccessTokenResponse_1.GetClientAccessTokenResponse(this.TokenRequests[responseIndex].Id, this.TokenRequests[responseIndex].TokenType);
    }
    /**
     * @internal Gets the expected response message count.
     *
     * @return  {number}      Number of items in response.
     */
    GetExpectedResponseMessageCount() {
        return this.TokenRequests.length;
    }
    /**
     * @internal Gets the request version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this request is supported.
     */
    GetMinimumRequiredServerVersion() {
        return ExchangeVersion_1.ExchangeVersion.Exchange2013;
    }
    /**
     * @internal Gets the name of the response message XML element.
     *
     * @return  {string}      XML element name.
     */
    GetResponseMessageXmlElementName() {
        return XmlElementNames_1.XmlElementNames.GetClientAccessTokenResponseMessage;
    }
    /**
     * @internal Gets the name of the response XML element.
     *
     * @return  {string}      XML element name.
     */
    GetResponseXmlElementName() {
        return XmlElementNames_1.XmlElementNames.GetClientAccessTokenResponse;
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name.
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.GetClientAccessToken;
    }
    /**
     * @internal Validate request.
     */
    Validate() {
        super.Validate();
        if (this.TokenRequests == null || this.TokenRequests.length == 0) {
            throw new ServiceValidationException_1.ServiceValidationException(Strings_1.Strings.HoldIdParameterIsNotSpecified);
        }
    }
    /**
     * @internal Writes the elements to XML writer.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.TokenRequests);
        for (let tokenRequestInfo of this.TokenRequests) {
            writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.TokenRequest);
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.Id, tokenRequestInfo.Id);
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.TokenType, ClientAccessTokenType_1.ClientAccessTokenType[tokenRequestInfo.TokenType]);
            if (!ExtensionMethods_1.StringHelper.IsNullOrEmpty(tokenRequestInfo.Scope)) {
                writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.HighlightTermScope, tokenRequestInfo.Scope);
            }
            writer.WriteEndElement();
        }
        writer.WriteEndElement();
    }
}
exports.GetClientAccessTokenRequest = GetClientAccessTokenRequest;
//# sourceMappingURL=GetClientAccessTokenRequest.js.map