"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetAppMarketplaceUrlRequest = void 0;
const EwsUtilities_1 = require("../EwsUtilities");
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const GetAppMarketplaceUrlResponse_1 = require("../Responses/GetAppMarketplaceUrlResponse");
const ExtensionMethods_1 = require("../../ExtensionMethods");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const SimpleServiceRequestBase_1 = require("./SimpleServiceRequestBase");
/**
 * @internal Represents a GetAppMarketplaceUrl request.
 *
 * @sealed
 */
class GetAppMarketplaceUrlRequest extends SimpleServiceRequestBase_1.SimpleServiceRequestBase {
    /**
     * @internal Initializes a new instance of the **GetAppMarketplaceUrlRequest** class.
     *
     * @param   {ExchangeService}   service   The service.
     */
    constructor(service) {
        super(service);
        /**
         * @internal Gets or sets the api version supported by the client.
         * This is used by EWS to generate a market place url with the correct version filter.
         *
         * @value	The Api version supported.
         */
        this.ApiVersionSupported = null;
        /**
         * @internal Gets or sets the Schema version supported by the client.
         * This is used by EWS to generate a market place url with the correct version filter.
         *
         * @value	The schema version supported.
         */
        this.SchemaVersionSupported = null;
    }
    /**
     * @internal Executes this request.
     *
     * @return  {Promise<GetAppMarketplaceUrlResponse>}      Service response  :Promise.
     */
    Execute() {
        return this.InternalExecute().then((serviceResponse) => {
            serviceResponse.ThrowIfNecessary();
            return serviceResponse;
        });
    }
    /**
     * @internal Gets the request version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this request is supported.
     */
    GetMinimumRequiredServerVersion() {
        return ExchangeVersion_1.ExchangeVersion.Exchange2013;
    }
    /**
     * @internal Gets the name of the response XML element.
     *
     * @return  {string}      XML element name.
     */
    GetResponseXmlElementName() {
        return XmlElementNames_1.XmlElementNames.GetAppMarketplaceUrlResponse;
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name.
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.GetAppMarketplaceUrlRequest;
    }
    /**
     * @internal Parses the response.
     *
     * @param   {any}   jsonBody   The js object response body.
     * @return  {any}              Response object.
     */
    ParseResponse(jsonBody) {
        let response = new GetAppMarketplaceUrlResponse_1.GetAppMarketplaceUrlResponse();
        response.LoadFromXmlJsObject(jsonBody, this.Service);
        return response;
    }
    /**
     * @internal Validate request.
     */
    Validate() {
        super.Validate();
        EwsUtilities_1.EwsUtilities.ValidateNonBlankStringParamAllowNull(this.ApiVersionSupported, "ApiVersionSupported");
        EwsUtilities_1.EwsUtilities.ValidateNonBlankStringParamAllowNull(this.SchemaVersionSupported, "SchemaVersionSupported");
    }
    /**
     * @internal Writes the elements to XML writer.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        if (!ExtensionMethods_1.StringHelper.IsNullOrEmpty(this.ApiVersionSupported)) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, "ApiVersionSupported", this.ApiVersionSupported);
        }
        if (!ExtensionMethods_1.StringHelper.IsNullOrEmpty(this.SchemaVersionSupported)) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, "SchemaVersionSupported", this.SchemaVersionSupported);
        }
    }
}
exports.GetAppMarketplaceUrlRequest = GetAppMarketplaceUrlRequest;
//# sourceMappingURL=GetAppMarketplaceUrlRequest.js.map