"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetAppManifestsRequest = void 0;
const EwsUtilities_1 = require("../EwsUtilities");
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const GetAppManifestsResponse_1 = require("../Responses/GetAppManifestsResponse");
const ExtensionMethods_1 = require("../../ExtensionMethods");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const SimpleServiceRequestBase_1 = require("./SimpleServiceRequestBase");
/**
 *  @internal Represents a GetAppManifests request.
 *
 * @sealed
*/
class GetAppManifestsRequest extends SimpleServiceRequestBase_1.SimpleServiceRequestBase {
    /**
     * @internal Initializes a new instance of the **GetAppManifestsRequest** class.
     *
     * @param   {ExchangeService}   service   The service.
     */
    constructor(service) {
        super(service);
        /**
         * @internal Gets or sets the api version supported by the client.
         * This tells Exchange service which app manifests should be returned based on the api version.
         *
         * @value	The Api version supported.
         */
        this.ApiVersionSupported = null;
        /**
         * @internal Gets or sets the Schema version supported by the client.
         * This tells Exchange service which app manifests should be returned based on the schema version.
         *
         * @value	The schema version supported.
         */
        this.SchemaVersionSupported = null;
    }
    /**
     * @internal Executes this request.
     *
     * @return  {Promise<GetAppManifestsResponse>}      Service response  :Promise.
     */
    Execute() {
        return this.InternalExecute().then((serviceResponse) => {
            serviceResponse.ThrowIfNecessary();
            return serviceResponse;
        });
    }
    /**
     * @internal Gets the request version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this request is supported.
     */
    GetMinimumRequiredServerVersion() {
        return ExchangeVersion_1.ExchangeVersion.Exchange2013;
    }
    /**
     * @internal Gets the name of the response XML element.
     *
     * @return  {string}      XML element name.
     */
    GetResponseXmlElementName() {
        return XmlElementNames_1.XmlElementNames.GetAppManifestsResponse;
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name.
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.GetAppManifestsRequest;
    }
    /**
     * @internal Parses the response.
     *
     * @param   {any}   jsonBody   The js object response body.
     * @return  {any}              Response object.
     */
    ParseResponse(jsonBody) {
        let response = new GetAppManifestsResponse_1.GetAppManifestsResponse();
        response.LoadFromXmlJsObject(jsonBody, this.Service);
        return response;
    }
    /**
     * @internal Validate request.
     */
    Validate() {
        super.Validate();
        EwsUtilities_1.EwsUtilities.ValidateNonBlankStringParamAllowNull(this.ApiVersionSupported, "ApiVersionSupported");
        EwsUtilities_1.EwsUtilities.ValidateNonBlankStringParamAllowNull(this.SchemaVersionSupported, "SchemaVersionSupported");
    }
    /**
     * @internal Writes the elements to XML writer.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        if (!ExtensionMethods_1.StringHelper.IsNullOrEmpty(this.ApiVersionSupported)) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, "ApiVersionSupported", this.ApiVersionSupported);
        }
        if (!ExtensionMethods_1.StringHelper.IsNullOrEmpty(this.SchemaVersionSupported)) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, "SchemaVersionSupported", this.SchemaVersionSupported);
        }
    }
}
exports.GetAppManifestsRequest = GetAppManifestsRequest;
//# sourceMappingURL=GetAppManifestsRequest.js.map