"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FindFolderRequest = void 0;
const FindFolderResponse_1 = require("../Responses/FindFolderResponse");
const XmlElementNames_1 = require("../XmlElementNames");
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const FindRequest_1 = require("./FindRequest");
/** @internal */
class FindFolderRequest extends FindRequest_1.FindRequest {
    constructor(service, errorHandlingMode) {
        super(service, errorHandlingMode);
    }
    CreateServiceResponse(service, responseIndex) { return new FindFolderResponse_1.FindFolderResponse(this.View.GetPropertySetOrDefault()); }
    GetMinimumRequiredServerVersion() { return ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1; }
    GetResponseMessageXmlElementName() { return XmlElementNames_1.XmlElementNames.FindFolderResponseMessage; }
    GetResponseXmlElementName() { return XmlElementNames_1.XmlElementNames.FindFolderResponse; }
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.FindFolder; }
}
exports.FindFolderRequest = FindFolderRequest;
//# sourceMappingURL=FindFolderRequest.js.map