"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExpandGroupRequest = void 0;
const ServiceErrorHandling_1 = require("../../Enumerations/ServiceErrorHandling");
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const XmlElementNames_1 = require("../XmlElementNames");
const ExpandGroupResponse_1 = require("../Responses/ExpandGroupResponse");
const MultiResponseServiceRequest_1 = require("./MultiResponseServiceRequest");
/** @internal */
class ExpandGroupRequest extends MultiResponseServiceRequest_1.MultiResponseServiceRequest {
    constructor(service) {
        super(service, ServiceErrorHandling_1.ServiceErrorHandling.ThrowOnError);
        this.emailAddress = null;
    }
    get EmailAddress() {
        return this.emailAddress;
    }
    set EmailAddress(value) {
        this.emailAddress = value;
    }
    CreateServiceResponse(service, responseIndex) { return new ExpandGroupResponse_1.ExpandGroupResponse(); }
    GetExpectedResponseMessageCount() { return 1; }
    GetMinimumRequiredServerVersion() { return ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1; }
    GetResponseMessageXmlElementName() { return XmlElementNames_1.XmlElementNames.ExpandDLResponseMessage; }
    GetResponseXmlElementName() { return XmlElementNames_1.XmlElementNames.ExpandDLResponse; }
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.ExpandDL; }
    Validate() {
        super.Validate();
        //EwsUtilities.ValidateParam(this.EmailAddress, "EmailAddress");
    }
    /**@internal */
    WriteElementsToXml(writer) {
        if (this.EmailAddress != null) {
            this.EmailAddress.WriteToXml(writer, XmlElementNames_1.XmlElementNames.Mailbox, XmlNamespace_1.XmlNamespace.Messages);
        }
    }
}
exports.ExpandGroupRequest = ExpandGroupRequest;
//# sourceMappingURL=ExpandGroupRequest.js.map