"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeleteItemRequest = void 0;
const ItemIdWrapperList_1 = require("../../Misc/ItemIdWrapperList");
const AffectedTaskOccurrence_1 = require("../../Enumerations/AffectedTaskOccurrence");
const SendCancellationsMode_1 = require("../../Enumerations/SendCancellationsMode");
const XmlAttributeNames_1 = require("../XmlAttributeNames");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const ServiceVersionException_1 = require("../../Exceptions/ServiceVersionException");
const ServiceResponse_1 = require("../Responses/ServiceResponse");
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const ExtensionMethods_1 = require("../../ExtensionMethods");
const Strings_1 = require("../../Strings");
const DeleteRequest_1 = require("./DeleteRequest");
/** @internal */
class DeleteItemRequest extends DeleteRequest_1.DeleteRequest {
    constructor(service, errorHandlingMode) {
        super(service, errorHandlingMode);
        this.itemIds = new ItemIdWrapperList_1.ItemIdWrapperList();
        this.affectedTaskOccurrences = null;
        this.sendCancellationsMode = null;
        this.SuppressReadReceipts = false;
    }
    get ItemIds() {
        return this.itemIds;
    }
    get AffectedTaskOccurrences() {
        return this.affectedTaskOccurrences;
    }
    set AffectedTaskOccurrences(value) {
        this.affectedTaskOccurrences = value;
    }
    get SendCancellationsMode() {
        return this.sendCancellationsMode;
    }
    set SendCancellationsMode(value) {
        this.sendCancellationsMode = value;
    }
    CreateServiceResponse(service, responseIndex) { return new ServiceResponse_1.ServiceResponse(); }
    GetExpectedResponseMessageCount() { return this.itemIds.Count; }
    GetMinimumRequiredServerVersion() { return ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1; }
    GetResponseMessageXmlElementName() { return XmlElementNames_1.XmlElementNames.DeleteItemResponseMessage; }
    GetResponseXmlElementName() { return XmlElementNames_1.XmlElementNames.DeleteItemResponse; }
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.DeleteItem; }
    InternalToJson(body) { throw new Error("DeleteItemRequest.ts - InternalToJson : Not implemented."); }
    Validate() {
        super.Validate();
        //EwsUtilities.ValidateParam(this.ItemIds, "ItemIds");
        if (this.SuppressReadReceipts && this.Service.RequestedServerVersion < ExchangeVersion_1.ExchangeVersion.Exchange2013) {
            throw new ServiceVersionException_1.ServiceVersionException(ExtensionMethods_1.StringHelper.Format(Strings_1.Strings.ParameterIncompatibleWithRequestVersion, "SuppressReadReceipts", ExchangeVersion_1.ExchangeVersion[ExchangeVersion_1.ExchangeVersion.Exchange2013]));
        }
    }
    /**@internal */
    WriteAttributesToXml(writer) {
        super.WriteAttributesToXml(writer);
        if (this.AffectedTaskOccurrences !== null) {
            writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.AffectedTaskOccurrences, AffectedTaskOccurrence_1.AffectedTaskOccurrence[this.AffectedTaskOccurrences]);
        }
        if (this.SendCancellationsMode !== null) {
            writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.SendMeetingCancellations, SendCancellationsMode_1.SendCancellationsMode[this.SendCancellationsMode]);
        }
        if (this.SuppressReadReceipts) {
            writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.SuppressReadReceipts, true);
        }
    }
    /**@internal */
    WriteElementsToXml(writer) {
        this.itemIds.WriteToXml(writer, XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.ItemIds);
    }
}
exports.DeleteItemRequest = DeleteItemRequest;
//# sourceMappingURL=DeleteItemRequest.js.map