"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateItemRequestBase = void 0;
const XmlElementNames_1 = require("../XmlElementNames");
const XmlAttributeNames_1 = require("../XmlAttributeNames");
const MessageDisposition_1 = require("../../Enumerations/MessageDisposition");
const SendInvitationsMode_1 = require("../../Enumerations/SendInvitationsMode");
const CreateRequest_1 = require("./CreateRequest");
/** @internal */
class CreateItemRequestBase extends CreateRequest_1.CreateRequest {
    constructor(service, errorHandlingModeServiceErrorHandling) {
        super(service, errorHandlingModeServiceErrorHandling);
        //private messageDisposition: MessageDisposition; - backing property not needed
        //private sendInvitationsMode: SendInvitationsMode;
        this.MessageDisposition = null;
        this.SendInvitationsMode = null;
    }
    get Items() {
        return this.Objects;
    }
    set Items(value) {
        this.Objects = value;
    }
    get EmitTimeZoneHeader() {
        for (var serviceObject of this.Items) {
            if (serviceObject.GetIsTimeZoneHeaderRequired(false /* isUpdateOperation */)) {
                return true;
            }
        }
        return false;
    }
    AddJsonProperties(jsonRequest, service) { throw new Error("CreateItemRequestBase.ts - AddJsonProperties : Not implemented."); }
    GetObjectCollectionXmlElementName() { return XmlElementNames_1.XmlElementNames.Items; }
    GetParentFolderXmlElementName() { return XmlElementNames_1.XmlElementNames.SavedItemFolderId; }
    GetResponseMessageXmlElementName() { return XmlElementNames_1.XmlElementNames.CreateItemResponseMessage; }
    GetResponseXmlElementName() { return XmlElementNames_1.XmlElementNames.CreateItemResponse; }
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.CreateItem; }
    Validate() {
        super.Validate();
        //EwsUtilities.ValidateParam(this.Items, "Items");
    }
    /**@internal */
    WriteAttributesToXml(writer) {
        super.WriteAttributesToXml(writer);
        if (this.MessageDisposition !== null) {
            writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.MessageDisposition, MessageDisposition_1.MessageDisposition[this.MessageDisposition]);
        }
        if (this.SendInvitationsMode !== null) {
            writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.SendMeetingInvitations, SendInvitationsMode_1.SendInvitationsMode[this.SendInvitationsMode]);
        }
    }
}
exports.CreateItemRequestBase = CreateItemRequestBase;
//# sourceMappingURL=CreateItemRequestBase.js.map