"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateItemRequest = void 0;
const CreateItemResponse_1 = require("../Responses/CreateItemResponse");
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const CreateItemRequestBase_1 = require("./CreateItemRequestBase");
/** @internal */
class CreateItemRequest extends CreateItemRequestBase_1.CreateItemRequestBase {
    constructor(service, errorHandlingModeServiceErrorHandling) {
        super(service, errorHandlingModeServiceErrorHandling);
    }
    CreateServiceResponse(service, responseIndex) { return new CreateItemResponse_1.CreateItemResponse(this.Items[responseIndex]); }
    GetMinimumRequiredServerVersion() { return ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1; }
    Validate() {
        super.Validate();
        // Validate each item.
        for (var item of this.Items) {
            item.Validate();
        }
    }
}
exports.CreateItemRequest = CreateItemRequest;
//# sourceMappingURL=CreateItemRequest.js.map