"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EwsLogging = void 0;
const ExtensionMethods_1 = require("../ExtensionMethods");
var isNode = (typeof window === 'undefined');
var util = undefined;
if (isNode) {
    util = require('util');
}
else {
    util = {
        inspect: (obj, option) => { return obj; }
    };
}
class EwsLogging {
    static Assert(condition, caller, message, always = false) {
        if ((this.DebugLogEnabled || always) && !condition)
            console.log(ExtensionMethods_1.StringHelper.Format("[{0}] {1}", caller, message));
    }
    static Log(message, always = false, expandObject = false) {
        if (this.DebugLogEnabled || always) {
            if (expandObject)
                console.log(util.inspect(message, { showHidden: false, depth: null, colors: true }));
            else
                console.log(message);
        }
    }
    static DebugLog(message, expandObject = false) {
        if (this.DebugLogEnabled) {
            if (expandObject)
                console.log(util.inspect(message, { showHidden: false, depth: null, colors: true }));
            else
                console.log(message);
        }
    }
}
exports.EwsLogging = EwsLogging;
EwsLogging.DebugLogEnabled = false;
//# sourceMappingURL=EwsLogging.js.map