"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TimeZonePeriod = void 0;
const EwsUtilities_1 = require("../../Core/EwsUtilities");
const XmlAttributeNames_1 = require("../../Core/XmlAttributeNames");
const XmlElementNames_1 = require("../../Core/XmlElementNames");
const ComplexProperty_1 = require("../ComplexProperty");
/**
 * @internal Represents a time zone period as defined in the EWS schema.
 */
class TimeZonePeriod extends ComplexProperty_1.ComplexProperty {
    /**
     * @internal Initializes a new instance of the **TimeZonePeriod** class.
     */
    constructor() {
        super();
    }
    /**
     * Gets a value indicating whether this period represents the Standard period.
     *
     * @value   <c>true</c> if this instance is standard period; otherwise, <c>false</c>.
     */
    get IsStandardPeriod() {
        return this.Name.toUpperCase() === TimeZonePeriod.StandardPeriodName.toUpperCase();
        // return string.Compare(
        //     this.name,
        //     TimeZonePeriod.StandardPeriodName,
        //     StringComparison.OrdinalIgnoreCase) == 0;
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}				jsObject	Json Object converted from XML.
     * @param   {ExchangeService}	service	The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        for (let key in jsObject) {
            switch (key) {
                case XmlAttributeNames_1.XmlAttributeNames.Id:
                    this.Id = jsObject[key];
                    break;
                case XmlAttributeNames_1.XmlAttributeNames.Name:
                    this.Name = jsObject[key];
                    break;
                case XmlAttributeNames_1.XmlAttributeNames.Bias:
                    this.Bias = EwsUtilities_1.EwsUtilities.XSDurationToTimeSpan(jsObject[key]);
                    break;
            }
        }
    }
    /**
     * @internal Writes the attributes to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteAttributesToXml(writer) {
        writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.Bias, EwsUtilities_1.EwsUtilities.TimeSpanToXSDuration(this.Bias));
        writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.Name, this.Name);
        writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.Id, this.Id);
    }
    /**
     * @internal Writes to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteToXml(writer) { super.WriteToXml(writer, XmlElementNames_1.XmlElementNames.Period); }
}
exports.TimeZonePeriod = TimeZonePeriod;
/** @internal */
TimeZonePeriod.StandardPeriodId = "Std";
/** @internal */
TimeZonePeriod.StandardPeriodName = "Standard";
/** @internal */
TimeZonePeriod.DaylightPeriodId = "Dlt";
/** @internal */
TimeZonePeriod.DaylightPeriodName = "Daylight";
//# sourceMappingURL=TimeZonePeriod.js.map