"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TaskSuggestion = void 0;
const EmailUserEntityCollection_1 = require("./EmailUserEntityCollection");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const ExtractedEntity_1 = require("./ExtractedEntity");
/**
 * Represents an TaskSuggestion object.
 */
class TaskSuggestion extends ExtractedEntity_1.ExtractedEntity {
    /**
     * @internal Initializes a new instance of the **TaskSuggestion** class.
     */
    constructor() {
        super();
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}				jsObject	Json Object converted from XML.
     * @param   {ExchangeService}	service	The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        super.LoadFromXmlJsObject(jsObject, service);
        for (let key in jsObject) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.NlgTaskString:
                    this.TaskString = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.NlgAssignees:
                    this.Assignees = new EmailUserEntityCollection_1.EmailUserEntityCollection();
                    this.Assignees.LoadFromXmlJsObject(jsObject[key], service);
                    break;
                default:
                    break;
            }
        }
    }
}
exports.TaskSuggestion = TaskSuggestion;
//# sourceMappingURL=TaskSuggestion.js.map