"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RuleError = void 0;
const RuleErrorCode_1 = require("../Enumerations/RuleErrorCode");
const RuleProperty_1 = require("../Enumerations/RuleProperty");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const ComplexProperty_1 = require("./ComplexProperty");
/**
 * Represents an error that occurred as a result of executing a rule operation.
 *
 * @sealed
 */
class RuleError extends ComplexProperty_1.ComplexProperty {
    /**
     * @internal Initializes a new instance of the **RuleError** class.
     */
    constructor() {
        super();
        /**
         * Rule property.
         */
        this.ruleProperty = RuleProperty_1.RuleProperty.RuleId;
        /**
         * Rule validation error code.
         */
        this.errorCode = RuleErrorCode_1.RuleErrorCode.ADOperationFailure;
        /**
         * Error message.
         */
        this.errorMessage = null;
        /**
         * Field value.
         */
        this.value = null;
    }
    /**
     * Gets the property which failed validation.
     */
    get RuleProperty() {
        return this.ruleProperty;
    }
    /**
     * Gets the validation error code.
     */
    get ErrorCode() {
        return this.errorCode;
    }
    /**
     * Gets the error message.
     */
    get ErrorMessage() {
        return this.errorMessage;
    }
    /**
     * Gets the value that failed validation.
     */
    get Value() {
        return this.value;
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}                 jsObject                Json Object converted from XML.
     * @param   {ExchangeService}     service                 The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        for (let key in jsObject) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.FieldURI:
                    this.ruleProperty = RuleProperty_1.RuleProperty[jsObject[key]];
                    break;
                case XmlElementNames_1.XmlElementNames.ErrorCode:
                    this.errorCode = RuleErrorCode_1.RuleErrorCode[jsObject[key]];
                    break;
                case XmlElementNames_1.XmlElementNames.ErrorMessage:
                    this.errorMessage = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.FieldValue:
                    this.value = jsObject[key];
                    break;
                default:
                    break;
            }
        }
    }
}
exports.RuleError = RuleError;
//# sourceMappingURL=RuleError.js.map