"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RecurrenceRange = void 0;
const EwsUtilities_1 = require("../../../Core/EwsUtilities");
const XmlElementNames_1 = require("../../../Core/XmlElementNames");
const XmlNamespace_1 = require("../../../Enumerations/XmlNamespace");
const ComplexProperty_1 = require("../../ComplexProperty");
/**
 * @internal Represents recurrence range with start and end dates.
 */
class RecurrenceRange extends ComplexProperty_1.ComplexProperty {
    constructor(startDate = null) {
        super();
        this.startDate = null;
        this.recurrence = null;
        this.startDate = startDate;
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @value   The name of the XML element.
     */
    get XmlElementName() { return null; }
    ;
    /**
     * @internal Gets or sets the recurrence.
     *
     * @value   The recurrence.
     */
    get Recurrence() {
        return this.recurrence;
    }
    set Recurrence(value) {
        this.recurrence = value;
    }
    /**
     * @internal Gets or sets the start date.
     *
     * @value   The start date.
     */
    get StartDate() {
        return this.startDate;
    }
    set StartDate(value) {
        this.SetFieldValue({ getValue: () => this.startDate, setValue: (updateValue) => { this.startDate = updateValue; } }, value);
    }
    /**
     * @internal Changes handler.
     */
    Changed() {
        if (this.Recurrence != null) {
            this.Recurrence.Changed();
        }
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}                 jsObject                Json Object converted from XML.
     * @param   {ExchangeService}     service                 The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        for (let key in jsObject) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.StartDate:
                    let startDate = service.ConvertStartDateToUnspecifiedDateTime(jsObject[key]);
                    if (startDate) {
                        this.startDate = startDate;
                    }
                    break;
                default:
                    break;
            }
        }
    }
    /**
     * @internal Setup the recurrence.
     *
     * @param   {Recurrence}   recurrence   The recurrence.
     */
    SetupRecurrence(recurrence) { recurrence.StartDate = this.StartDate; }
    /**
     * @internal Writes elements to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.StartDate, EwsUtilities_1.EwsUtilities.DateTimeToXSDate(this.StartDate));
    }
}
exports.RecurrenceRange = RecurrenceRange;
//# sourceMappingURL=RecurrenceRange.js.map