"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DailyPattern = void 0;
const XmlElementNames_1 = require("../../../Core/XmlElementNames");
const Recurrence_IntervalPattern_1 = require("./Recurrence.IntervalPattern");
/**
 * Represents a recurrence pattern where each occurrence happens a specific number of days after the previous one.
 */
class DailyPattern extends Recurrence_IntervalPattern_1.IntervalPattern {
    /**
     * @internal Gets the name of the XML element.
     *
     * @value   The name of the XML element.
     */
    get XmlElementName() {
        return XmlElementNames_1.XmlElementNames.DailyRecurrence;
    }
    constructor(startDate, interval) {
        if (arguments.length === 0) {
            super();
            return;
        }
        super(startDate, interval);
    }
}
exports.DailyPattern = DailyPattern;
//# sourceMappingURL=Recurrence.DailyPattern.js.map