"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhysicalAddressDictionary = void 0;
const DictionaryKeyType_1 = require("../Enumerations/DictionaryKeyType");
const PhysicalAddressEntry_1 = require("./PhysicalAddressEntry");
const DictionaryProperty_1 = require("./DictionaryProperty");
class PhysicalAddressDictionary extends DictionaryProperty_1.DictionaryProperty {
    constructor() {
        super(DictionaryKeyType_1.DictionaryKeyType.PhysicalAddressKey);
    }
    _getItem(key) {
        return this.Entries.get(key);
    }
    _setItem(key, value) {
        if (value == null) {
            this.InternalRemove(key);
        }
        else {
            value.Key = key;
            this.InternalAddOrReplace(value);
        }
    }
    CreateEntryInstance() { return new PhysicalAddressEntry_1.PhysicalAddressEntry(); }
    TryGetValue(key, physicalAddress) { return this.Entries.tryGetValue(key, physicalAddress); }
}
exports.PhysicalAddressDictionary = PhysicalAddressDictionary;
//# sourceMappingURL=PhysicalAddressDictionary.js.map