"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhoneNumberDictionary = void 0;
const DictionaryKeyType_1 = require("../Enumerations/DictionaryKeyType");
const PhoneNumberEntry_1 = require("./PhoneNumberEntry");
const DictionaryProperty_1 = require("./DictionaryProperty");
class PhoneNumberDictionary extends DictionaryProperty_1.DictionaryProperty {
    constructor() {
        super(DictionaryKeyType_1.DictionaryKeyType.PhoneNumberKey);
    }
    _getItem(key) {
        return this.Entries.get(key).PhoneNumber;
    }
    _setItem(key, value) {
        if (value == null) {
            this.InternalRemove(key);
        }
        else {
            var entry = { outValue: null };
            if (this.Entries.tryGetValue(key, entry)) {
                entry.outValue.PhoneNumber = value;
                this.Changed();
            }
            else {
                let newEntry = new PhoneNumberEntry_1.PhoneNumberEntry(key, value);
                this.InternalAdd(newEntry);
            }
        }
    }
    CreateEntryInstance() { return new PhoneNumberEntry_1.PhoneNumberEntry(); }
    GetFieldURI() { return "contacts:PhoneNumber"; }
    TryGetValue(key, phoneNumber) {
        var entry = { outValue: null };
        if (this.Entries.tryGetValue(key, entry)) {
            phoneNumber.outValue = entry.outValue.PhoneNumber;
            return true;
        }
        else {
            phoneNumber = null;
            return false;
        }
    }
}
exports.PhoneNumberDictionary = PhoneNumberDictionary;
//# sourceMappingURL=PhoneNumberDictionary.js.map