"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OnlineMeetingSettings = void 0;
const EwsUtilities_1 = require("../Core/EwsUtilities");
const LobbyBypass_1 = require("../Enumerations/LobbyBypass");
const OnlineMeetingAccessLevel_1 = require("../Enumerations/OnlineMeetingAccessLevel");
const Presenters_1 = require("../Enumerations/Presenters");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const XmlNamespace_1 = require("../Enumerations/XmlNamespace");
const ComplexProperty_1 = require("./ComplexProperty");
/**
 * Represents Lync online meeting settings.
 */
class OnlineMeetingSettings extends ComplexProperty_1.ComplexProperty {
    constructor(lobbyBypassOrOnlineMeetingSettings, accessLevel, presenters) {
        super();
        this.lobbyBypass = LobbyBypass_1.LobbyBypass.Disabled;
        this.accessLevel = OnlineMeetingAccessLevel_1.OnlineMeetingAccessLevel.Locked;
        this.presenters = Presenters_1.Presenters.Disabled;
        switch (arguments.length) {
            case 1:
                let onlineMeetingSettings = lobbyBypassOrOnlineMeetingSettings;
                EwsUtilities_1.EwsUtilities.ValidateParam(lobbyBypassOrOnlineMeetingSettings, "OnlineMeetingSettings");
                this.LobbyBypass = onlineMeetingSettings.LobbyBypass;
                this.AccessLevel = onlineMeetingSettings.AccessLevel;
                this.Presenters = onlineMeetingSettings.Presenters;
                break;
            case 3:
                this.lobbyBypass = lobbyBypassOrOnlineMeetingSettings;
                this.accessLevel = accessLevel;
                this.presenters = presenters;
                break;
            default:
                break;
        }
    }
    /**
     * Gets or sets the online meeting setting that describes whether users dialing in by phone have to wait in the lobby.
     */
    get LobbyBypass() {
        return this.lobbyBypass;
    }
    set LobbyBypass(value) {
        this.SetFieldValue({ getValue: () => this.lobbyBypass, setValue: (fieldValue) => { this.LobbyBypass = fieldValue; } }, value);
    }
    /**
     * Gets or sets the online meeting setting that describes access permission to the meeting.
     */
    get AccessLevel() {
        return this.accessLevel;
    }
    set AccessLevel(value) {
        this.SetFieldValue({ getValue: () => this.accessLevel, setValue: (fieldValue) => { this.accessLevel = fieldValue; } }, value);
    }
    /**
     * Gets or sets the online meeting setting that defines the meeting leaders.
     */
    get Presenters() {
        return this.presenters;
    }
    set Presenters(value) {
        this.SetFieldValue({ getValue: () => this.presenters, setValue: (fieldValue) => { this.presenters = fieldValue; } }, value);
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}                 jsObject                Json Object converted from XML.
     * @param   {ExchangeService}     service                 The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        for (let key in jsObject) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.LobbyBypass:
                    this.lobbyBypass = LobbyBypass_1.LobbyBypass[jsObject[key]];
                    break;
                case XmlElementNames_1.XmlElementNames.AccessLevel:
                    this.accessLevel = OnlineMeetingAccessLevel_1.OnlineMeetingAccessLevel[jsObject[key]];
                    break;
                case XmlElementNames_1.XmlElementNames.Presenters:
                    this.presenters = Presenters_1.Presenters[jsObject[key]];
                    break;
                default:
                    break;
            }
        }
    }
    /**
     * @internal Writes elements to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.LobbyBypass, this.LobbyBypass);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.AccessLevel, this.AccessLevel);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.Presenters, this.Presenters);
    }
}
exports.OnlineMeetingSettings = OnlineMeetingSettings;
//# sourceMappingURL=OnlineMeetingSettings.js.map