"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OccurrenceInfo = void 0;
const ItemId_1 = require("./ItemId");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const ComplexProperty_1 = require("./ComplexProperty");
/**
 * Encapsulates information on the occurrence of a recurring appointment.
 */
class OccurrenceInfo extends ComplexProperty_1.ComplexProperty {
    /**
     *  @internal Initializes a new instance of the **OccurrenceInfo** class.
     */
    constructor() {
        super();
        this.itemId = null;
        this.start = null;
        this.end = null;
        this.originalStart = null;
    }
    /**
     * Gets the Id of the occurrence.
     */
    get ItemId() {
        return this.itemId;
    }
    /**
     * Gets the start date and time of the occurrence.
     */
    get Start() {
        return this.start;
    }
    /**
     * Gets the end date and time of the occurrence.
     */
    get End() {
        return this.end;
    }
    /**
     * Gets the original start date and time of the occurrence.
     */
    get OriginalStart() {
        return this.originalStart;
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}                 jsObject                Json Object converted from XML.
     * @param   {ExchangeService}     service                 The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        for (let key in jsObject) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.ItemId:
                    this.itemId = new ItemId_1.ItemId();
                    this.itemId.LoadFromXmlJsObject(jsObject[key], service);
                    break;
                case XmlElementNames_1.XmlElementNames.Start:
                    this.start = service.ConvertUniversalDateTimeStringToLocalDateTime(jsObject[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.End:
                    this.end = service.ConvertUniversalDateTimeStringToLocalDateTime(jsObject[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.OriginalStart:
                    this.originalStart = service.ConvertUniversalDateTimeStringToLocalDateTime(jsObject[key]);
                    break;
                default:
                    break;
            }
        }
    }
}
exports.OccurrenceInfo = OccurrenceInfo;
//# sourceMappingURL=OccurrenceInfo.js.map