"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NormalizedBody = void 0;
const BodyType_1 = require("../Enumerations/BodyType");
const ExtensionMethods_1 = require("../ExtensionMethods");
const XmlAttributeNames_1 = require("../Core/XmlAttributeNames");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const ComplexProperty_1 = require("./ComplexProperty");
/**
 * Represents the normalized body of an item - the HTML fragment representation of the body.
 */
class NormalizedBody extends ComplexProperty_1.ComplexProperty {
    /**
     * Initializes a new instance of the **NormalizedBody** class.
     */
    constructor() {
        super();
        this.bodyType = BodyType_1.BodyType.HTML;
        this.text = null;
        this.isTruncated = false;
    }
    /**
     * Gets the type of the normalized body's text.
     */
    get BodyType() {
        return this.bodyType;
    }
    set BodyType(value) {
        this.bodyType = value;
    }
    /**
     * Gets the text of the normalized body.
     */
    get Text() {
        return this.text;
    }
    set Text(value) {
        this.text = value;
    }
    /**
     * Gets whether the body is truncated.
     */
    get IsTruncated() {
        return this.isTruncated;
    }
    set IsTruncated(value) {
        this.isTruncated = value;
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}				jsObject	Json Object converted from XML.
     * @param   {ExchangeService}	service	The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        for (let key in jsObject) {
            switch (key) {
                case XmlAttributeNames_1.XmlAttributeNames.BodyType:
                    this.bodyType = BodyType_1.BodyType[jsObject[key]];
                    break;
                case XmlAttributeNames_1.XmlAttributeNames.IsTruncated:
                    this.isTruncated = ExtensionMethods_1.Convert.toBool(jsObject[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.NormalizedBody:
                    this.text = jsObject[key];
                    break;
                default:
                    break;
            }
        }
    }
    /**
     * Returns a **String** that represents the current **Object**.
     *
     * @return  {string}      A **String** that represents the current **Object**.
     */
    ToString() { return this.Text || ExtensionMethods_1.StringHelper.Empty; }
    toString() { return this.ToString(); }
    /**
     * @internal Writes attributes to XML.
     *
     * @param {EwsServiceXmlWriter} writer  The writer.
     */
    WriteAttributesToXml(writer) {
        writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.BodyType, this.BodyType);
    }
    /**
     * @internal Writes elements to XML.
     *
     * @param {EwsServiceXmlWriter} writer  The writer.
     */
    WriteElementsToXml(writer) {
        if (!ExtensionMethods_1.StringHelper.IsNullOrEmpty(this.Text)) {
            writer.WriteValue(this.Text, XmlElementNames_1.XmlElementNames.NormalizedBody);
        }
    }
}
exports.NormalizedBody = NormalizedBody;
//# sourceMappingURL=NormalizedBody.js.map