"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MimeContentUTF8 = void 0;
const ExtensionMethods_1 = require("../ExtensionMethods");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const MimeContentBase_1 = require("./MimeContentBase");
/**
 * Represents the MIME content of an item.
 */
class MimeContentUTF8 extends MimeContentBase_1.MimeContentBase {
    constructor(characterSet = null) {
        super();
        this.CharacterSet = characterSet;
        this.Content = "utf-8"; //c# - Encoding.UTF8.BodyName, nodejs - utf8 not utf-8
        this.xmlElementName = XmlElementNames_1.XmlElementNames.MimeContentUTF8;
    }
    /**
     * Returns a **String** that represents the current **Object**.
     *
     * @return  {string}      A **String** that represents the current **Object**.
     */
    ToString() {
        return this.Content || ExtensionMethods_1.StringHelper.Empty;
        //ref: //info: 
        //todo: implement arraybuffer and encoding using TextDecoder or some other tech
        //            if (this.Content == null)
        //            {
        //                return string.Empty;
        //            }
        //            else
        //            {
        //                try
        //                {
        //                    // Try to convert to original MIME content using specified charset. If this fails, 
        //                    // return the Base64 representation of the content.
        //                    // Note: Encoding.GetString can throw DecoderFallbackException which is a subclass
        //                    // of ArgumentException.
        //                    // it should always be UTF8 encoding for MimeContentUTF8
        //                    return Encoding.UTF8.GetString(this.Content);
        //                }
        //                catch (ArgumentException)
        //                {
        //                    return Convert.ToBase64String(this.Content);
        //                }
        //            }
    }
    toString() { return this.ToString(); }
}
exports.MimeContentUTF8 = MimeContentUTF8;
//# sourceMappingURL=MimeContentUTF8.js.map