"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MimeContentBase = void 0;
const ExtensionMethods_1 = require("../ExtensionMethods");
const XmlAttributeNames_1 = require("../Core/XmlAttributeNames");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const ComplexProperty_1 = require("./ComplexProperty");
/**
 * Represents the MIME content of an item.
 */
class MimeContentBase extends ComplexProperty_1.ComplexProperty {
    constructor() {
        super(...arguments);
        /**
         * to set XMLElementName when reading XML JsObject value.
         */
        this.xmlElementName = XmlElementNames_1.XmlElementNames.MimeContent;
    }
    /**
     * Gets or sets the character set of the content.
     */
    get CharacterSet() {
        return this.characterSet;
    }
    set CharacterSet(value) {
        this.SetFieldValue({ getValue: () => this.characterSet, setValue: (updateValue) => { this.characterSet = updateValue; } }, value);
    }
    /**
     * Gets or sets the content.  - ews-javascript-api this is base64 value without encoding applied.
     */
    get Content() {
        return this.content;
    }
    set Content(value) {
        this.SetFieldValue({ getValue: () => this.content, setValue: (updateValue) => { this.content = updateValue; } }, value);
    }
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}				jsObject	Json Object converted from XML.
     * @param   {ExchangeService}	service	The service.
     */
    LoadFromXmlJsObject(jsObject /*JsonObject*/, service) {
        for (let key in jsObject) {
            switch (key) {
                case XmlAttributeNames_1.XmlAttributeNames.CharacterSet:
                    this.characterSet = jsObject[key];
                    break;
                case this.xmlElementName: //ref: text value in xml2jsobject
                    this.content = jsObject[key];
                    ;
                    break;
                default:
                    break;
            }
        }
    }
    /**
     * @internal Writes attributes to XML.
     *
     * @param {EwsServiceXmlWriter} writer  The writer.
     */
    WriteAttributesToXml(writer) {
        writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.CharacterSet, this.CharacterSet);
    }
    /**
     * @internal Writes elements to XML.
     *
     * @param {EwsServiceXmlWriter} writer  The writer.
     */
    WriteElementsToXml(writer) {
        if (!ExtensionMethods_1.StringHelper.IsNullOrEmpty(this.Content)) {
            writer.WriteValue(this.Content, this.xmlElementName);
            //writer.WriteBase64ElementValue(this.Content);
        }
    }
}
exports.MimeContentBase = MimeContentBase;
//# sourceMappingURL=MimeContentBase.js.map