"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ItemAttachment = void 0;
const ItemInfo_1 = require("../Core/ServiceObjects/Items/ItemInfo");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const ExtensionMethods_1 = require("../ExtensionMethods");
const Strings_1 = require("../Strings");
const ServiceValidationException_1 = require("../Exceptions/ServiceValidationException");
const Attachment_1 = require("./Attachment");
/**
 * Represents an item attachment.
 */
class ItemAttachment extends Attachment_1.Attachment {
    constructor(ownerOrService) {
        super(ownerOrService);
        /**
         * The item associated with the attachment.
         */
        this.item = null;
    }
    /**
     * Gets the item associated with the attachment.
     */
    get Item() {
        return this.item;
    }
    set Item(value) {
        super.ThrowIfThisIsNotNew();
        //todo: implement logic for onchange
        if (this.item !== null) {
            //this.item.OnChange.Remove(this.ItemChanged);
        }
        this.item = value;
        if (this.item !== null) {
            //this.item.OnChange.Add(this.ItemChanged);
        }
    }
    /** to workaround base.Item property accessor of c# //ref: //info: */
    _setItem(value) {
        this.item = value;
    }
    /**
     * @internal Obtains EWS XML element name for this object.
     *
     * @return  {string}      The XML element name.
     */
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.ItemAttachment; }
    /**
     * Implements the OnChange event handler for the item associated with the attachment.
     *
     * @param   {ServiceObject}   serviceObject   The service object that triggered the OnChange event.
     */
    ItemChanged(serviceObject) {
        if (this.Owner != null) {
            this.Owner.PropertyBag.Changed();
        }
    }
    Load(bodyTypeOrPeoperties, additionalProperties) {
        let argsLength = arguments.length;
        let props = null;
        let bodyType = null;
        if (argsLength === 1) {
            props = bodyTypeOrPeoperties;
        }
        if (argsLength === 2) {
            bodyType = bodyTypeOrPeoperties;
        }
        if (argsLength > 2) {
            throw new Error("ItemAttachment.ts - Load with " + argsLength + " parameters, invalid number of arguments, check documentation and try again.");
        }
        return this.InternalLoad(bodyType, props);
    }
    /**
     * @internal Loads from XMLjsObject.
     *
     * @param   {any}               jsObject   The json property.
     * @param   {ExchangeService}   service        [description]
     */
    LoadFromXmlJsObject(jsObject, service) {
        super.LoadFromXmlJsObject(jsObject, service);
        for (let key in jsObject) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.Item:
                case XmlElementNames_1.XmlElementNames.CalendarItem:
                case XmlElementNames_1.XmlElementNames.Contact:
                case XmlElementNames_1.XmlElementNames.DistributionList:
                case XmlElementNames_1.XmlElementNames.Conversation:
                case XmlElementNames_1.XmlElementNames.Message:
                case XmlElementNames_1.XmlElementNames.MeetingCancellation:
                case XmlElementNames_1.XmlElementNames.MeetingMessage:
                case XmlElementNames_1.XmlElementNames.MeetingRequest:
                case XmlElementNames_1.XmlElementNames.MeetingResponse:
                case XmlElementNames_1.XmlElementNames.Persona:
                case XmlElementNames_1.XmlElementNames.PostItem:
                case XmlElementNames_1.XmlElementNames.Task:
                    let itemObj = jsObject[key];
                    if (itemObj != null) {
                        this.item = (new ItemInfo_1.ItemInfo()).CreateEwsObjectFromXmlElementName(this.Service, key);
                        if (this.item != null) {
                            this.item.LoadFromXmlJsObject(itemObj, this.Service, true);
                        }
                    }
                    break;
                default:
                    break;
            }
        }
    }
    //ReadElementsFromXmlJsObject(reader: any): void { throw new Error("ItemAttachment.ts - TryReadElementFromXmlJsObject : Not implemented."); }    
    ReadElementsFromXmlJsObjectToPatch(reader) { throw new Error("ItemAttachment.ts - TryReadElementFromXmlToPatch : Not implemented."); }
    /**
     * @internal Validates this instance.
     *
     * @param   {number}   attachmentIndex   Index of this attachment.
     */
    Validate(attachmentIndex) {
        if (ExtensionMethods_1.StringHelper.IsNullOrEmpty(this.Name)) {
            throw new ServiceValidationException_1.ServiceValidationException(ExtensionMethods_1.StringHelper.Format(Strings_1.Strings.ItemAttachmentMustBeNamed, attachmentIndex));
        }
        // Recurse through any items attached to item attachment.
        this.Item.Attachments.Validate();
    }
    /**
     * @internal Writes the properties of this object as XML elements.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer to write the elements to.
     */
    WriteElementsToXml(writer) {
        super.WriteElementsToXml(writer);
        this.Item.WriteToXml(writer);
    }
}
exports.ItemAttachment = ItemAttachment;
//# sourceMappingURL=ItemAttachment.js.map