"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InternetMessageHeader = void 0;
const ExtensionMethods_1 = require("../ExtensionMethods");
const XmlAttributeNames_1 = require("../Core/XmlAttributeNames");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const ComplexProperty_1 = require("./ComplexProperty");
/**
 * Represents an Internet message header.
 */
class InternetMessageHeader extends ComplexProperty_1.ComplexProperty {
    /**
     * @internal Initializes a new instance of the **InternetMessageHeader** class.
     */
    constructor() {
        super();
        this.name = null;
        this.value = null;
    }
    /**
     * The name of the header.
     */
    get Name() {
        return this.name;
    }
    set Name(value) {
        this.SetFieldValue({ getValue: () => this.name, setValue: (nameValue) => { this.name = nameValue; } }, value);
    }
    /**
     * The value of the header.
     */
    get Value() {
        return this.value;
    }
    set Value(value) {
        this.SetFieldValue({ getValue: () => this.value, setValue: (valueValue) => { this.value = valueValue; } }, value);
    }
    /**
     * @internal Loads from XMLJsObject.
     *
     * @param   {any}   jsonProperty   The json property.
     * @param   {ExchangeService}   service        The ExchangeService instance
     */
    LoadFromXmlJsObject(jsObject, service) {
        for (let key in jsObject) {
            switch (key) {
                case XmlAttributeNames_1.XmlAttributeNames.HeaderName:
                    this.name = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.InternetMessageHeader: //JsonObject.JsonValueString: //ref: //info: custom parser in ExtensionMethods uses name of type when there is attribute value as well as text value
                    this.value = jsObject[key];
                    break;
                default:
                    break;
            }
        }
    }
    /**
     * Obtains a string representation of the header.
     *
     * @return  {string}      The string representation of the header.
     */
    ToString() { return ExtensionMethods_1.StringHelper.Format("{0}={1}", this.Name, this.Value); }
    toString() { return this.ToString(); }
    /**
     * @internal Writes the attributes to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteAttributesToXml(writer) { writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.HeaderName, this.Name); }
    /**
     * @internal Writes elements to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) { writer.WriteValue(this.Value, this.Name); }
}
exports.InternetMessageHeader = InternetMessageHeader;
//# sourceMappingURL=InternetMessageHeader.js.map