"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmailAddressEntry = void 0;
const EmailAddressKey_1 = require("../Enumerations/EmailAddressKey");
const ExchangeVersion_1 = require("../Enumerations/ExchangeVersion");
const MailboxType_1 = require("../Enumerations/MailboxType");
const EmailAddress_1 = require("./EmailAddress");
const XmlAttributeNames_1 = require("../Core/XmlAttributeNames");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const DictionaryEntryProperty_1 = require("./DictionaryEntryProperty");
class EmailAddressEntry extends DictionaryEntryProperty_1.DictionaryEntryProperty {
    constructor(key = EmailAddressKey_1.EmailAddressKey.EmailAddress1, emailAddress = new EmailAddress_1.EmailAddress()) {
        super(key);
        this.emailAddress = null;
        this.keyType = EmailAddressKey_1.EmailAddressKey;
        this.emailAddress = emailAddress;
        if (this.emailAddress != null) {
            this.emailAddress.OnChange.push(this.EmailAddressChanged.bind(this));
        }
    }
    get EmailAddress() {
        return this.emailAddress;
    }
    set EmailAddress(value) {
        this.SetFieldValue({ getValue: () => this.emailAddress, setValue: (address) => { this.emailAddress = address; } }, value);
        if (this.emailAddress != null) {
            this.emailAddress.OnChange.push(this.EmailAddressChanged.bind(this));
        }
    }
    EmailAddressChanged(complexProperty) { this.Changed(); }
    LoadFromXmlJsObject(jsonProperty, service) {
        for (var key in jsonProperty) {
            switch (key) {
                case XmlAttributeNames_1.XmlAttributeNames.Key:
                    this.Key = EmailAddressKey_1.EmailAddressKey[jsonProperty[key]];
                    break;
                case XmlAttributeNames_1.XmlAttributeNames.Name:
                    this.EmailAddress.Name = jsonProperty[key];
                    break;
                case XmlAttributeNames_1.XmlAttributeNames.RoutingType:
                    this.EmailAddress.RoutingType = jsonProperty[key];
                    break;
                case XmlAttributeNames_1.XmlAttributeNames.MailboxType:
                    this.EmailAddress.MailboxType = MailboxType_1.MailboxType.FromEwsEnumString(jsonProperty[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.EmailAddress:
                    this.EmailAddress.Address = jsonProperty[key];
                    break;
            }
        }
        //ref: ews-javascript-api specific workaround for text node in complexproperty
        if (jsonProperty[XmlElementNames_1.XmlElementNames.Entry]) {
            if (this.emailAddress.Address === null) {
                this.emailAddress.Address = jsonProperty[XmlElementNames_1.XmlElementNames.Entry];
            }
        }
    }
    // ReadAttributesFromXmlJsObject(reader: EwsServiceXmlReader): any { throw new Error("EmailAddressEntry.ts - ReadAttributesFromXml : Not implemented."); }
    // ReadTextValueFromXmlJsObject(reader: EwsServiceXmlReader): any { throw new Error("EmailAddressEntry.ts - ReadTextValueFromXml : Not implemented."); }
    /**@internal */
    WriteAttributesToXml(writer) {
        super.WriteAttributesToXml(writer);
        if (writer.Service.RequestedServerVersion > ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1) {
            writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.Name, this.EmailAddress.Name);
            writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.RoutingType, this.EmailAddress.RoutingType);
            if (this.EmailAddress.MailboxType != MailboxType_1.MailboxType.Unknown) {
                writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.MailboxType, MailboxType_1.MailboxType.ToEwsEnumString(this.EmailAddress.MailboxType));
            }
        }
    }
    /**@internal */
    WriteElementsToXml(writer) { writer.WriteValue(this.EmailAddress.Address, XmlElementNames_1.XmlElementNames.EmailAddress); }
}
exports.EmailAddressEntry = EmailAddressEntry;
//# sourceMappingURL=EmailAddressEntry.js.map