"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmailAddressDictionary = void 0;
const DictionaryKeyType_1 = require("../Enumerations/DictionaryKeyType");
const EmailAddressEntry_1 = require("./EmailAddressEntry");
const DictionaryProperty_1 = require("./DictionaryProperty");
class EmailAddressDictionary extends DictionaryProperty_1.DictionaryProperty {
    constructor() {
        super(DictionaryKeyType_1.DictionaryKeyType.EmailAddressKey);
    }
    /**
     * Gets or sets the e-mail address at the specified key.
     *
     * @param   {EmailAddressKey}   key   The key of the e-mail address to get or set.
     * @return  {EmailAddress}         The e-mail address at the specified key.
     */
    _getItem(key) {
        return this.Entries.get(key).EmailAddress;
    }
    /**
     * Gets or sets the e-mail address at the specified key.
     *
     * @param   {EmailAddressKey}   key   The key of the e-mail address to get or set.
     * @return  {EmailAddress}         The e-mail address at the specified key.
     */
    _setItem(key, value) {
        if (value == null) {
            this.InternalRemove(key);
        }
        else {
            var entry = { outValue: null };
            if (this.Entries.tryGetValue(key, entry)) {
                entry.outValue.EmailAddress = value;
                this.Changed();
            }
            else {
                let newEntry = new EmailAddressEntry_1.EmailAddressEntry(key, value);
                this.InternalAdd(newEntry);
            }
        }
    }
    /**
     * @internal Creates instance of dictionary entry.
     *
     * @return  {EmailAddressEntry}      New instance.
     */
    CreateEntryInstance() { return new EmailAddressEntry_1.EmailAddressEntry(); }
    /**
     * @internal Gets the field URI.
     *
     * @return  {string}      Field URI.
     */
    GetFieldURI() { return "contacts:EmailAddress"; }
    /**
     * Tries to get the e-mail address associated with the specified key.
     *
     * @param   {EmailAddressKey}   key            The key.
     * @param   {IOutParam<EmailAddress>}   emailAddress   When this method returns, contains the e-mail address associated with the specified key, if the key is found; otherwise, null. This parameter is passed uninitialized.
     * @return  {boolean}                  true if the Dictionary contains an e-mail address associated with the specified key; otherwise, false.
     */
    TryGetValue(key, emailAddress) {
        let entry = { outValue: null };
        if (this.Entries.tryGetValue(key, entry)) {
            emailAddress.outValue = entry.outValue.EmailAddress;
            return true;
        }
        else {
            emailAddress = null;
            return false;
        }
    }
}
exports.EmailAddressDictionary = EmailAddressDictionary;
//# sourceMappingURL=EmailAddressDictionary.js.map