"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmailAddress = void 0;
const EwsUtilities_1 = require("../Core/EwsUtilities");
const ItemId_1 = require("./ItemId");
const MailboxType_1 = require("../Enumerations/MailboxType");
const ExtensionMethods_1 = require("../ExtensionMethods");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const XmlNamespace_1 = require("../Enumerations/XmlNamespace");
const ComplexProperty_1 = require("./ComplexProperty");
/**
 * Represents an e-mail address.
 */
class EmailAddress extends ComplexProperty_1.ComplexProperty {
    constructor(smtpAddressOrNameOrMailbox, smtpAddressOrAddress, routingType, mailboxType, itemId) {
        super();
        /**
         * Display name.
         */
        this.name = null;
        /**
         * Email address.
         */
        this.address = null;
        /**
         * Routing type.
         */
        this.routingType = null;
        /**
         * Mailbox type.
         */
        this.mailboxType = null;
        /**
         * ItemId - Contact or PDL.
         */
        this.id = null;
        if (smtpAddressOrNameOrMailbox instanceof EmailAddress) {
            EwsUtilities_1.EwsUtilities.ValidateParam(smtpAddressOrNameOrMailbox, "mailbox");
            this.Name = smtpAddressOrNameOrMailbox.Name;
            this.Address = smtpAddressOrNameOrMailbox.Address;
            this.RoutingType = smtpAddressOrNameOrMailbox.RoutingType;
            this.MailboxType = smtpAddressOrNameOrMailbox.MailboxType;
            this.Id = smtpAddressOrNameOrMailbox.Id;
        }
        else {
            let argsLength = arguments.length;
            if (argsLength === 1) {
                this.address = smtpAddressOrNameOrMailbox;
            }
            else if (argsLength > 1) {
                this.name = smtpAddressOrNameOrMailbox;
                this.address = smtpAddressOrAddress;
                if (argsLength >= 3) {
                    this.routingType = routingType;
                }
                if (argsLength >= 4) {
                    this.mailboxType = mailboxType;
                }
                if (argsLength === 5) {
                    this.id = itemId;
                }
            }
        }
    }
    /**
     * Gets or sets the name associated with the e-mail address.
     */
    get Name() {
        return this.name;
    }
    set Name(value) {
        this.SetFieldValue({ getValue: () => this.name, setValue: (updateValue) => { this.name = updateValue; } }, value);
    }
    /**
     * Gets or sets the actual address associated with the e-mail address. The type of the Address property must match the specified routing type. If RoutingType is not set, Address is assumed to be an SMTP address.
     */
    get Address() {
        return this.address;
    }
    set Address(value) {
        this.SetFieldValue({ getValue: () => this.address, setValue: (updateValue) => { this.address = updateValue; } }, value);
    }
    /**
     * Gets or sets the routing type associated with the e-mail address. If RoutingType is not set, Address is assumed to be an SMTP address.
     */
    get RoutingType() {
        return this.routingType;
    }
    set RoutingType(value) {
        this.SetFieldValue({ getValue: () => this.routingType, setValue: (updateValue) => { this.routingType = updateValue; } }, value);
    }
    /**
     * Gets or sets the type of the e-mail address.
     */
    get MailboxType() {
        return this.mailboxType;
    }
    set MailboxType(value) {
        this.SetFieldValue({ getValue: () => this.mailboxType, setValue: (updateValue) => { this.mailboxType = updateValue; } }, value);
    }
    /**
     * Gets or sets the Id of the contact the e-mail address represents. When Id is specified, Address should be set to null.
     */
    get Id() {
        return this.id;
    }
    set Id(value) {
        this.SetFieldValue({ getValue: () => this.id, setValue: (updateValue) => { this.id = updateValue; } }, value);
    }
    /**
     * Get a string representation for using this instance in a search filter.
     * ISearchStringProvider.GetSearchString
     *
     * @return  {string}      String representation of instance.
     */
    GetSearchString() {
        return this.Address;
    }
    ReadElementsFromXmlJsObject(reader) { throw new Error("EmailAddress.ts - TryReadElementFromXmlJsObject : Not implemented."); }
    //todo: implement UpdateFromXmlJsObject
    /**
     * @internal Loads service object from XML.
     *
     * @param   {any}                 jsObject                Json Object converted from XML.
     * @param   {ExchangeService}     service                 The service.
     */
    LoadFromXmlJsObject(jsObject, service) {
        for (let key in jsObject) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.Name:
                    this.name = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.EmailAddress:
                    this.address = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.RoutingType:
                    this.routingType = jsObject[key];
                    break;
                case XmlElementNames_1.XmlElementNames.MailboxType:
                    this.mailboxType = MailboxType_1.MailboxType.FromEwsEnumString(jsObject[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.ItemId:
                    this.id = new ItemId_1.ItemId();
                    this.id.LoadFromXmlJsObject(jsObject[key], service);
                    break;
                default:
                    break;
            }
        }
    }
    /**
     * Returns a **string** that represents the current **object**.
     *
     * @return  {string}      A **string** that represents the current **object**.
     */
    ToString() {
        let addressPart = null;
        if (ExtensionMethods_1.StringHelper.IsNullOrEmpty(this.Address)) {
            return ExtensionMethods_1.StringHelper.Empty;
        }
        if (!ExtensionMethods_1.StringHelper.IsNullOrEmpty(this.RoutingType)) {
            addressPart = this.RoutingType + ":" + this.Address;
        }
        else {
            addressPart = this.Address;
        }
        if (!ExtensionMethods_1.StringHelper.IsNullOrEmpty(this.Name)) {
            return this.Name + " <" + addressPart + ">";
        }
        else {
            return addressPart;
        }
    }
    toString() {
        return this.ToString();
    }
    /**
     * @internal Writes elements to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.Name, this.Name);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.EmailAddress, this.Address);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.RoutingType, this.RoutingType);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.MailboxType, MailboxType_1.MailboxType.ToEwsEnumString(this.MailboxType));
        if (this.Id != null) {
            this.Id.WriteToXml(writer); //, XmlElementNames.ItemId);
        }
    }
}
exports.EmailAddress = EmailAddress;
/**
 * SMTP routing type.
 */
EmailAddress.SmtpRoutingType = "SMTP";
//# sourceMappingURL=EmailAddress.js.map